<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\PDF;

use Proxim\Application;
use Proxim\Site\Site;
use Proxim\Tools;
use Proxim\Util\DateUtils;

/**
 * @since 1.5
 */
class HTMLTemplateActivityLogList extends HTMLTemplate
{
    public $application;

    public $activitylog;

    /**
     * @param $activitylog
     * @param $smarty
     *
     * @throws Exception
     */
    public function __construct($activitylog, $smarty)
    {
        $this->application = Application::getInstance();

        $this->activitylog = $activitylog;

        $this->smarty = $smarty;

        $this->title = 'Activity Log';
    }

    /**
     * Use this method to return the result of a smarty template when assign data only locally with $this->smarty->assign().
     *
     * @param string $templatePath relative path the template file, from the module root dir
     *
     * @return mixed
     */
    public function fetch($templatePath)
    {
        $template = $this->application->smarty->createTemplate(
            $templatePath,
            $this->smarty
        );

        return $template->fetch();
    }

    public function getTemplate($template_name) {
        $template = false;
        $default_template = rtrim(CURRENT_ACTIVITYLOG_MODULE_DIR, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR  . 'pdf' . DIRECTORY_SEPARATOR . $template_name . '.tpl';
        if (file_exists($default_template)) {
            $template = $default_template;
        } 

        return $template;
    }

    /**
     * Returns the template's HTML content.
     *
     * @return string HTML content
     */
    public function getContent()
    {
        $this->smarty->assign([
            'activitylog' => $this->activitylog,
            'style_tab' => $this->fetch($this->getTemplate('activitylog.style-tab'))
        ]);

        return $this->fetch($this->getTemplate('activitylog'));
    }

    /**
     * Returns the template filename.
     *
     * @return string filename
     */
    public function getFilename()
    {
        return sprintf('ACTLOG%06d', DateUtils::now()) . '.pdf';
    }

    /**
     * Returns the template filename when using bulk rendering.
     *
     * @return string filename
     */
    public function getBulkFilename()
    {
        return 'activitylog.pdf';
    }

    /**
     * Returns the template's HTML header.
     *
     * @return string HTML header
     */
    public function getHeader()
    {
        $this->assignCommonHeaderData();
        $this->smarty->assign(['header' => 'Activity Log']);
        return $this->fetch($this->getTemplate('header'));
    }
}