<form method="GET" class="mb20" autocomplete="off">
    <input type="hidden" name="page" value="{$selected_page}"/>
    <div class="row">
        <div class="form-group col-md-4">
            <input type='text' class="form-control" placeholder="Search User ID, IP or Event Type" value="{$query}" name="query" />
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="from" data-target-input="nearest">
                <input type='text' class="form-control datetimepicker-input" placeholder="From" value="{$date_from}" data-target="#from" name="from" />
                <div class="input-group-append" data-target="#from" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="to" data-target-input="nearest">
                <input type='text' class="form-control datetimepicker-input" placeholder="To" value="{$date_to}" data-target="#to" name="to" />
                <div class="input-group-append" data-target="#to" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-2">
            <button type="submit" name="search" class="btn btn-primary"><i class="fa fa-search mr5"></i>Search</button>
        </div>
    </div>
</form> 

{if count($activities)}
    <div class="table-responsive">
        <table class="table table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>User</th>
                    <th>IP Address</th>
                    <th>Object</th>
                    <th>Event Type</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                {foreach $activities as $activity}
                    <tr>
                        <td>
                            {if $activity.user_object == 'employee'}
                                <a class="fw-bold" href="{$base_uri}/employees/edit/{$activity.user_id}" data-ajax="/employees/edit/{$activity.user_id}">{$activity.name|ucwords}</a>
                            {else}
                                <a class="fw-bold" href="{$base_uri}/customers/edit/{$activity.user_id}" data-ajax="/customers/edit/{$activity.user_id}">{$activity.name|ucwords}</a>
                            {/if}
                        </td>
                        <td>{$activity.user_ip}</td>
                        <td>{$activity.object|ucfirst} | #{$activity.object_id}</td>
                        <td>{$activity.event|strtolower}</td>
                        <td>
                            <span class="js_moment" data-time="{$activity.date_add}">{$activity.date_add}</span>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No activities to show</strong></p>
    </div>
{/if}