<!-- Authorize.net -->
<div class="tab-pane" id="authorize">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fas fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using Authorize.net, you'll need to create an account at <a target="_blank" href="https://www.authorize.net/">Authorize.net</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateAuthorizeSettings">
        <input type="hidden" name="site_id" value="{$authorizeConfiguration.SITE_ID}"/>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Authorize.net Enabled</label>
            <div class="col-sm-9">
                <label class="switch" for="authorize_enabled">
                    <input type="checkbox" name="authorize_enabled" id="authorize_enabled" {if $authorizeConfiguration.AUTHORIZE_ENABLED == '1'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Enable payments via Credit Card
                </span>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Default
            </label>
            <div class="col-sm-9">
                <label class="switch" for="default_method_authorize">
                    <input type="checkbox" name="default_method_enabled" id="default_method_authorize" {if $authorizeConfiguration.PAYMENT_METHOD_DEFAULT == 'authorize'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Make it the default payment method of the site
                </span>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Authorize.net Mode</label>
            <div class="col-sm-9">
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="authorize_mode" id="authorize_live" {if $authorizeConfiguration.AUTHORIZE_MODE == 'live'}checked{/if} value="live">
                    <label for="authorize_live">Live</label>
                </div>
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="authorize_mode" id="authorize_test" {if $authorizeConfiguration.AUTHORIZE_MODE == 'test'}checked{/if} value="test">
                    <label for="authorize_test">Test</label>
                    </div>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">API Login ID</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="authorize_api_login_id" id="authorize_api_login_id" maxlength="255" value="{$authorizeConfiguration.AUTHORIZE_API_LOGIN_ID}">
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Transaction Key</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="authorize_transaction_key" id="authorize_transaction_key" maxlength="255" value="{$authorizeConfiguration.AUTHORIZE_TRANSACTION_KEY}">
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- Authorize.net -->