{if $can_import_order}
    <li>
        <a href="#" data-toggle="modal" data-url="#bluepostImport" class="dropdown-item pointer">
            <em class="icon ni ni-wordpress fa-fw mr5"></em> <span>{if $order_imported}Update Paper{else}WP Import{/if}</span>
        </a>
    </li>

    <!-- WP Import -->
    <script id="bluepostImport" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/bluepost/publish" method="POST">
            <input type="hidden" name="order_id" value="{$order.id}">
            <div class="modal-header">
                <h5 class="modal-title">Import to WordPress</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="control-label text-left">Title</label>
                    <div class="input-group">
                    {if $order.isProgramming || $order.isCalculations}
                        <input name="title" type="text" class="form-control form-control-lg" value="{$order.serviceTypeTitle}">
                    {else}
                        <input name="title" type="text" class="form-control form-control-lg" value="{$order.title}">
                    {/if}
                    </div>
                </div>
 
                <div class="form-group">
                    <label class="control-label text-left">Category</label>
                    <div class="input-group">
                        <input name="category" type="text" class="form-control form-control-lg" value="{$order.topicCategory}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label text-left">Instructions</label>
                    <textarea data-height="200" name="instructions" type="text" class="form-control summernote-minimal">{$order.paperDetails nofilter}</textarea>
                </div>
             
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Publish</button>
            </div>
        </form>
    </script>
    <!-- WP Import -->

{/if}