{if $can_import_order}
    <div data-toggle="modal" data-url="#bluepostImport" class="dropdown-item pointer js_unpin-post">
        <div class="action no-desc">
            <i class="fab fa-wordpress-simple fa-fw mr5"></i> <span>{if $order_imported}Update Paper{else}WP Import{/if}</span>
        </div>
    </div>

    <!-- WP Import -->
    <script id="bluepostImport" type="text/template">
        <form class="js_ajax-forms p0 m0" data-url="/bluepost/publish" method="POST">
            <input type="hidden" name="order_id" value="{$order.id}">
            <div class="modal-header">
                <h5 class="modal-title">Import to WordPress</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label class="control-label text-left">Title</label>
                    <div class="input-group">
                    {if $order.isProgramming || $order.isCalculations}
                        <input name="title" type="text" class="form-control" value="{$order.serviceTypeTitle}">
                    {else}
                        <input name="title" type="text" class="form-control" value="{$order.title}">
                    {/if}
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label text-left">Category</label>
                    <div class="input-group">
                        <input name="category" type="text" class="form-control" value="{$order.topicCategory}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="control-label text-left">Instructions</label>
                    <div class="input-group">
                        <textarea data-height="200" name="instructions" type="text" class="form-control js_summernote">{$order.paperDetails nofilter}</textarea>
                    </div>
                </div>
             
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Publish</button>
            </div>
        </form>
    </script>
    <!-- WP Import -->

{/if}