<div class="row g-gs">
    <div class="col-lg-6">
        <form class="js_ajax-forms" data-url="/creditfine/updatePenaltySettings" method="POST">
            <div class="card-title">
                <h6 class="title">Lateness Fines</h6>
            </div>

            <div class="form-group">
                <label class="form-label">Penalty for lateness for less than 1 hour</label>
                <div class="form-control-wrap w-150px">
                    <div class="form-icon lg form-icon-right">
                    <em class="icon ni ni-percent"></em>
                    </div>
                    <input type="text" class="form-control form-control-lg force-integer" name="CREDIT_FINE_PASSED_1_HRS" {if $creditfineConfiguration.CREDIT_FINE_PASSED_1_HRS}value="{$creditfineConfiguration.CREDIT_FINE_PASSED_1_HRS}"{else}value="0"{/if}>
                </div>
            </div>

            <div class="form-group">
                <label class="form-label">Penalty for lateness for more than 1 hour</label>
                <div class="form-control-wrap w-150px">
                    <div class="form-icon lg form-icon-right">
                    <em class="icon ni ni-percent"></em>
                    </div>
                    <input type="text" class="form-control form-control-lg force-integer" name="CREDIT_FINE_PASSED_2_HRS" {if $creditfineConfiguration.CREDIT_FINE_PASSED_2_HRS}value="{$creditfineConfiguration.CREDIT_FINE_PASSED_2_HRS}"{else}value="0"{/if}>
                </div>
            </div>
            

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>

            <button type="submit" class="btn btn-success">Save Changes</button>
        </form>
    </div>

    <div class="col-lg-6">
        <div class="card-title">
            <div class="card-title-group">
                <div class="card-title">
                    <h6 class="title">Fines</h6>
                </div>
                <div class="card-tools">
                    <button data-toggle="modal" data-url="#modalAddFine" data-size="small" class="btn btn-primary">
                        <em class="icon ni ni-plus"></em> <span>Add Fine</span>
                    </button>
                </div>
            </div>
        </div>

        <div class="card-inner">
            {foreach $fines as $fine}
                <div class="row rounded mb-2">
                    <div class="col-md-8 p-2 bg-primary-dim fw-bold d-flex align-items-center rounded-left">
                        {$fine.name}
                    </div>
                    <div class="col-md-2 p-2 bg-primary fw-bold text-white  d-flex align-items-center">
                        {if $fine.type == 'amount'}{formatPrice($fine.value)}{else}{numberFormat($fine.value)}%{/if}
                    </div>
                    <div class="col-md-2 p-2 bg-primary-dim fw-bold text-white rounded-right">
                        <div class="drodown">
                            <a href="#" class="dropdown-toggle btn btn-icon btn-trigger me-n1" data-toggle="dropdown" aria-expanded="false">
                                <em class="icon ni ni-more-h"></em>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end">
                                <ul class="link-list-opt no-bdr">
                                    <li>
                                        <a data-toggle="modal" data-url="#modalEditFine" data-options='{$fine|json_encode nofilter}' data-size="small" href="#">
                                            <em class="icon ni ni-edit"></em><span>Edit</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" class="js_deleter" data-handle="fine_type" data-id="{$fine.fine_type_id}">
                                            <em class="icon ni ni-trash"></em><span>Delete</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>
    </div>
</div>

<!-- Add Fine Modal -->
<script id="modalAddFine" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/creditfine/postFine" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Fine</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Name</label>
                <input name="name" class="form-control form-control-lg" placeholder="eg. Plagiarism"/>
            </div>

            <div class="form-group">
                <label class="form-label text-left">Fine Type</label>
                <select class="form-select" data-ui="lg" name="fine_type" data-combo="fine_type">
                    <option value="percentage" selected="">Percentage of the Order Price</option>
                    <option value="amount">Amount</option>
                </select>
            </div>

            <div class="form-group" id="fine_type">
                <div class="switch-combo x-hidden" data-combo-value="amount">
                    <label class="form-label text-left">Amount</label>
                    <div class="form-control-wrap">
                        <div class="form-icon lg form-icon-left">
                            <em class="icon ni ni-sign-dollar"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg force-integer" name="amount">
                    </div>
                </div>
                <div class="switch-combo" data-combo-value="percentage">
                    <label class="form-label text-left">Percentage</label>
                    <div class="form-control-wrap">
                        <input type="text" class="form-control form-control-lg force-integer" name="percentage">
                        <div class="form-icon lg form-icon-right">
                            <em class="icon ni ni-percent"></em>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Fine</button>
        </div>
    </form>
</script>
<!-- Add Fine Modal -->

<!-- Edit Fine Modal -->
<script id="modalEditFine" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/creditfine/postFine" method="POST" autocomplete="off">
        <input type="hidden" name="fine_type_id" value="{literal}{{fine_type_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Fine</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Name</label>
                <input name="name" class="form-control form-control-lg" placeholder="eg. Plagiarism" value="{literal}{{name}}{/literal}"/>
            </div>

            <div class="form-group">
                <label class="form-label text-left">Fine Type</label>
                <select class="form-select" data-ui="lg" name="fine_type" data-combo="fine_type">
                    <option {literal}{{#is_percentage}}selected{{/is_percentage}}{/literal} value="percentage" selected="">Percentage of the Order Price</option>
                    <option {literal}{{#is_amount}}selected{{/is_amount}}{/literal} value="amount">Amount</option>
                </select>
            </div>

            <div class="form-group" id="fine_type">
                <div class="switch-combo {literal}{{^is_amount}}x-hidden{{/is_amount}}{/literal}" data-combo-value="amount">
                    <label class="form-label text-left">Amount</label>
                    <div class="form-control-wrap">
                        <div class="form-icon lg form-icon-left">
                            <em class="icon ni ni-sign-dollar"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg force-integer" name="amount" value="{literal}{{value}}{/literal}">
                    </div>
                </div>
                <div class="switch-combo {literal}{{^is_percentage}}x-hidden{{/is_percentage}}{/literal}" data-combo-value="percentage">
                    <label class="form-label text-left">Percentage</label>
                    <div class="form-control-wrap">
                        <input type="text" class="form-control form-control-lg force-integer" name="percentage" value="{literal}{{value}}{/literal}">
                        <div class="form-icon lg form-icon-right">
                            <em class="icon ni ni-percent"></em>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Fine Modal -->