{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="wide-lg">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title">Credits</h3>
                </div>
                <!-- .nk-block-head-content -->
            </div>
            <!-- .nk-block-between -->
        </div>

        <div class="nk-block">
            <div class="card card-bordered card-preview table-responsive">
                {if count($rows)}
                    <table class="table table-orders is-compact mb-0">
                        <thead>
                            <tr class="tb-odr-head">
                                <th class="tb-odr-info">Amount</th>
                                <th class="tb-odr-info">Resolved</th>
                                <th class="tb-odr-info">Date</th>
                                <th class="tb-odr-action">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $rows as $row}
                                <tr class="tb-odr-item">
                                    <td class="tb-odr-info"><span class="text-success fw-bold">+{formatPrice($row.amount)}</span></td>
                                    <td class="tb-odr-info">
                                        <span class="badge badge-dot {if $row.resolved}badge-success{else}badge-danger{/if}">{if $row.resolved}Yes{else}No{/if}</span>
                                    </td>
                                    <td class="tb-odr-info">
                                        <span class="js_moment" data-time="{$row.date_add}">{$row.date_add}</span>
                                    </td>
                                    <td class="tb-odr-action">
                                        <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-sm btn-danger js_deleter" data-handle="creditfine" data-id="{$row.credit_fine_id}">
                                            <i class="icon ni ni-trash-alt"></i> <span>Delete</span>
                                        </button>
                                        {if !$row.resolved}
                                            <button class="btn btn-sm btn-success js_resolve-creditfine" data-id="{$row.credit_fine_id}">
                                                <i class="icon ni ni-check"></i> <span>Resolve</span>
                                            </button>
                                        {/if}
                                        <button data-toggle="modal" data-url="#viewCFDetails" data-options='{$row|json_encode nofilter}' data-size="small" class="btn btn-sm btn-primary">
                                            <i class="icon ni ni-eye"></i> <span>View</span>
                                        </button>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                {else}
                    <div class="text-center x-muted py-5">
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">The list is empty</h6>
                    </div>
                {/if}
            </div>
        </div>
    </div>

    <script id="viewCFDetails" type="text/template">
        <form class="js_ajax-forms" data-url="/creditfine/createCharge" method="POST">
            <input type="hidden" name="node_id" value="{literal}{{credit_fine_id}}{/literal}">
            <div class="modal-header">
                <h5 class="modal-title">View Details</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="icon ni ni-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="control-label text-left">Amount</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="amount" type="text" class="form-control force-integer" value="{literal}{{amount}}{/literal}">
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label text-left">Description</label>
                    <textarea name="description" type="text" class="form-control js_autosize">{literal}{{description}}{/literal}</textarea>
                </div>
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Update</button>
            </div>
        </form>
    </script>
{/block}

{block name="custom_js"}
    <script type="text/javascript">
        $(function () { 
            $(document).on('click', '.js_resolve-creditfine', function (e) {
                e.preventDefault();
                var id = $(this).data('id');
    
                confirm('Resolve Charge', 'Are you sure you want to resolve this charge?', function () {
                    $.post(proxim.api_path + '/creditfine/resolveCharge', { 'id': id }, function (response) {
                        if (response.callback) {
                            eval(response.callback);
                        }

                        setInterval(function () {
                            window.location.reload();
                        }, 600);
                    }, 'json')
                        .fail(function () {
                            modal('#modal-message', { title: 'Error', message: 'There is something that went wrong!' });
                        });
                });
            });
        });
    </script>
    {/block}