{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <div class="pull-right">
                <button class="btn btn-primary btn-sm" onclick="history.back()">
                    <i class="fa fa-arrow-left mr5"></i> Go Back
                </button>
            </div> 
            <i class="fas fa-money-bill-wave mr10"></i> 
            <strong>Credits</strong>
        </div>

        <div class="card-body">
            {if count($rows)}
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover js_dataTable">
                        <thead>
                            <tr>
                                <th>Amount</th>
                                <th>Resolved</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $rows as $row}
                                <tr>
                                    <td><span class="text-success fw-bold">+{formatPrice($row.amount)}</span></td>
                                    <td>
                                        <span class="badge {if $row.resolved}badge-success{else}badge-danger{/if}">{if $row.resolved}Yes{else}No{/if}</span>
                                    </td>
                                    <td>
                                        <span class="js_moment" data-time="{$row.date_add}">{$row.date_add}</span>
                                    </td>
                                    <td>
                                        <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="creditfine" data-id="{$row.credit_fine_id}">
                                            <i class="fa fa-trash-alt"></i> Delete
                                        </button>
                                        {if !$row.resolved}
                                            <button class="btn btn-xs btn-success js_resolve-creditfine" data-id="{$row.credit_fine_id}">
                                                <i class="fa fa-check"></i> Resolve
                                            </button>
                                        {/if}
                                        <button data-toggle="modal" data-url="#viewCFDetails" data-options='{$row|json_encode nofilter}' data-size="small" class="btn btn-xs btn-primary">
                                            <i class="fa fa-eye"></i> View
                                        </button>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}
                </div>
            {else}
                <div class="text-center x-muted"> 
                    <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                    <p class="mb10"><strong>No fines to show</strong></p>
                </div>
            {/if}
        </div>
    </div>

    <script id="viewCFDetails" type="text/template">
        <form class="js_ajax-forms" data-url="/creditfine/createCharge" method="POST">
            <input type="hidden" name="node_id" value="{literal}{{credit_fine_id}}{/literal}">
            <div class="modal-header">
                <h5 class="modal-title">View Details</h5>
                <span class="modal-close" data-dismiss="modal" aria-label="Close">
                    <i class="fa fa-times"></i>
                </span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label class="control-label text-left">Amount</label>
                    <div class="input-group">
                        <div class="input-group-prepend"> 
                            <span class="input-group-text">$</span> 
                        </div>
                        <input name="amount" type="text" class="form-control force-integer" value="{literal}{{amount}}{/literal}">
                    </div>
                </div>
                <div class="form-group">
                    <label class="control-label text-left">Description</label>
                    <textarea name="description" type="text" class="form-control js_autosize">{literal}{{description}}{/literal}</textarea>
                </div>
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Update</button>
            </div>
        </form>
    </script>
{/block}

{block name="custom_js"}
    <script type="text/javascript">
        $(function () { 
            $(document).on('click', '.js_resolve-creditfine', function (e) {
                e.preventDefault();
                var id = $(this).data('id');
    
                confirm('Resolve Charge', 'Are you sure you want to resolve this charge?', function () {
                    $.post(proxim.api_path + '/creditfine/resolveCharge', { 'id': id }, function (response) {
                        if (response.callback) {
                            eval(response.callback);
                        }

                        setInterval(function () {
                            window.location.reload();
                        }, 600);
                    }, 'json')
                        .fail(function () {
                            modal('#modal-message', { title: 'Error', message: 'There is something that went wrong!' });
                        });
                });
            });
        });
    </script>
    {/block}