{if count($rows)}
    <div class="table-responsive">
        <table class="table table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Resolved</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $rows as $row}
                    <tr>
                        <td>{$row.type|ucfirst}</td>
                        <td><span class="badge {if $row.type == 'credit'}badge-success{else}badge-danger{/if} fw-bold">{formatPrice($row.amount)}</span></td>
                        <td>
                            <span class="badge {if $row.resolved}badge-success{else}badge-danger{/if}">{if $row.resolved}Resolved at <span class="js_moment" data-time="{$row.resolved_at}">{$row.resolved_at}</span>{else}No{/if}</span>
                        </td>
                        <td>
                            <span class="js_moment" data-time="{$row.date_add}">{$row.date_add}</span>
                        </td>
                        <td>
                            <button data-toggle="modal" data-url="#viewCFDetails" data-options='{$row|json_encode nofilter}' data-size="small" class="btn btn-xs btn-primary">
                                <i class="fa fa-eye"></i> View
                            </button>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No charges to show</strong></p>
    </div>
{/if}

<script id="viewCFDetails" type="text/template">
    <div class="modal-header">
        <h5 class="modal-title">View Details</h5>
        <span class="modal-close" data-dismiss="modal" aria-label="Close">
            <i class="fa fa-times"></i>
        </span>
    </div>
    <div class="modal-body">
        <div>{literal}{{description}}{/literal}</div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
    </div>
</script>
