<h4 class="mt0">Adding Customer Reviews on your website</h4>
<ol class="ml0 pl10">
    <li class="mb5">Log in to your <strong>WordPress dashboard</strong>.</li>
    <li class="mb5">Click <strong>Pages</strong>, from the navigation menu.</li>
    <li class="mb5">Click <strong>Add New</strong> button, you’ll be directed to the WordPress visual editor. Add a title for the page e.g. Reviews.</li>
    <li class="mb5">Click the <strong>Plus</strong> icon on the block area or the top of the editor.</li>
    <li class="mb5">Choose the <strong>Custom HTML</strong> icon under the Formatting. Search <strong>Custom HTML</strong> option if you can't find it.</li>
    <li class="mb5"><strong>Copy and Paste</strong> the below HTML code to your WordPress page.</li>
    <li class="mb5">Alternatively, you can switch to the editor mode. Click the <strong>three dots menu</strong> on the top right side corner, then select <strong>Code Editor</strong>.</li>
    <li class="mb5">Click <strong>Preview</strong> if you want to see the results before publishing.</li>
</ol>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.2/codemirror.min.css" integrity="sha512-xIf9AdJauwKIVtrVRZ0i4nHP61Ogx9fSRAkCLecmE2dL/U8ioWpDvFCAy4dcfecN72HHB9+7FfQj3aiO68aaaw==" crossorigin="anonymous" />
{literal}
    <textarea class="form-control" name="custom-code" id="custom-code">
    <style>
        .Testimonials__page {
            margin-bottom: 50px;
        }
        .Testimonials__show-more button {
            font-weight: 700 !important;
            color: #2e5b74!important;
            font-size: 16px!important;
            padding: 17px 30px!important;
            -webkit-box-shadow: 0 4px 6px 0 hsla(0,0%,75.7%,.3)!important;
            box-shadow: 0 4px 6px 0 hsla(0,0%,75.7%,.3)!important;
            background: #f7f6f6!important;
            border: 1px solid #eaeaea!important;
            border-radius: 10px!important;
        }
    </style>

    <link type="text/css" rel="stylesheet" href="/static/css/testimonials.css">

    <div class="Testimonials__page" data-tab-container="testimonials" data-rating="8" data-rating-type="rating">
        <div class="Testimonials__List"></div>
        <div class="Testimonials__loader active"></div>
        <div class="Testimonials__show-more">
            <button class="Testimonials__show-more-btn" onclick="getMore(10)">Show more reviews</button>
        </div>
    </div>

    <script type="text/javascript" src="/static/js/testimonials.js"></script>
</textarea>
{/literal}

{block name="custom_js"}
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.58.2/codemirror.min.js" integrity="sha512-UxcTlYsLkcuGZL9JNnMsfo3p7VFSmcgBjH1VUSM82Okk5ni52bk7vz9f2p+D1VnMcNUmMzbzgWqWcdJ2j8Svow==" crossorigin="anonymous"></script>
<script type="text/javascript">
    CodeMirror.fromTextArea(document.getElementById('custom-code'), {
        lineNumbers: true,
        readOnly: true,
        mode:  "htmlmixed"
    });
    </script>
{/block}