<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Module\PaymentModule;
use Proxim\Site\Site;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class Intasend extends PaymentModule
{
    /**
    * Intasend configuration
    */
    const INTASEND_ENABLED = 'INTASEND_ENABLED';
    const INTASEND_MODE = 'INTASEND_MODE';
    const INTASEND_PUBLIC_KEY = 'INTASEND_PUBLIC_KEY';

    public function __construct()
    {
        $this->name = 'intasend';
        $this->icon = 'fab fa-intasend';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';
        $this->displayName = 'Intasend';
        $this->description = 'Set up Intasend as a payment method and enable users to pay without leaving your website';

        $this->bootstrap = true;
        parent::__construct();
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin === true;
    }

    public function install()
    { 
        return parent::install() && 
        $this->registerHook('paymentOptions') &&
        $this->registerHook('verifyPayment') &&
        $this->registerHook('displayClientHeader') &&
        $this->registerHook('displayClientFooter');
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . $templateName.'.tpl');
    }

    public function getContent()
    {
        $application = $this->application;

        $intasendConfiguration = Configuration::getMultiple([
                'PAYMENT_METHOD_DEFAULT',
                self::INTASEND_ENABLED,
                self::INTASEND_MODE,
                self::INTASEND_PUBLIC_KEY,
                'SITE_ID'
            ],
            $application->site->id
        );

        $this->smarty->assign([
            'intasendConfiguration' => $intasendConfiguration
        ]);

        return $this->getTemplateContent('configure');
    }

    public function updateIntasendSettings() {
        $app = $this->application;
        $payload = $app->request->post();

        $site_id = (int) $app->request->post('site_id');
        Configuration::updateValue('PAYMENT_METHOD_DEFAULT', ArrayUtils::has($payload, 'default_method_enabled') ? $this->name : '' , false, $site_id);
        Configuration::updateValue(self::INTASEND_ENABLED, (ArrayUtils::get($payload, 'intasend_enabled') == 'on') ? true : false , false, $site_id);
        Configuration::updateValue(self::INTASEND_MODE, ArrayUtils::get($payload, 'intasend_mode'), false, $site_id);
        Configuration::updateValue(self::INTASEND_PUBLIC_KEY, ArrayUtils::get($payload, 'intasend_public_key'), false, $site_id);

        return $app->sendResponse([
            "success" => true,
			"message" => "System settings have been updated"
        ]);
    }
}