<!-- Jenga -->
<div class="tab-pane" id="jengacheckout">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fas fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using Jenga, you'll need to create an account at <a target="_blank" href="https://jengapgw.io">Jenga</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateJengaSettings">
        <input type="hidden" name="site_id" value="{$jengaConfiguration.SITE_ID}"/>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Jenga Enabled
            </label>
            <div class="col-sm-9">
                <label class="switch" for="jenga_enabled">
                    <input type="checkbox" name="jenga_enabled" id="jenga_enabled" {if $jengaConfiguration.JENGA_ENABLED == '1'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Enable payments via Credit Card
                </span>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Default
            </label>
            <div class="col-sm-9">
                <label class="switch" for="default_method_jengacheckout">
                    <input type="checkbox" name="default_method_enabled" id="default_method_jengacheckout" {if $jengaConfiguration.PAYMENT_METHOD_DEFAULT == 'jengacheckout'}checked="checked"{/if}>
                    <span class="slider round"></span>
                </label>
                <span class="help-block">
                    Make it the default payment method of the site
                </span>
            </div>
        </div>
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Jenga Mode
            </label>
            <div class="col-sm-9">
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="jenga_mode" id="jenga_live" {if $jengaConfiguration.JENGA_MODE == 'live'}checked{/if} value="live">
                    <label for="jenga_live">Live</label>
                </div>
                <div class="radio radio-primary radio-inline">
                    <input type="radio" name="jenga_mode" id="jenga_test" {if $jengaConfiguration.JENGA_MODE == 'test'}checked{/if} value="test">
                    <label for="jenga_test">Test</label>
                    </div>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Username</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="jenga_username" id="jenga_username" maxlength="255" value="{$jengaConfiguration.JENGA_USERNAME}">
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Password</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="jenga_password" id="jenga_password" maxlength="255" value="{$jengaConfiguration.JENGA_PASSWORD}">
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">API Key</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="jenga_api_key" id="jenga_api_key" maxlength="255" value="{$jengaConfiguration.JENGA_API_KEY}">
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Outlet Code</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="jenga_outlet_code" id="jenga_outlet_code" maxlength="255" value="{$jengaConfiguration.JENGA_OUTLET_CODE}">
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">Merchant Code</label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="jenga_merchant_code" id="jenga_merchant_code" maxlength="255" value="{$jengaConfiguration.JENGA_MERCHANT_CODE}">
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- Jenga -->