<div class="row">
    <div class="col-md-6">
        {if count($tipPresets)}
 
            <table class="table table-orders mb-4">
                <thead class="tb-odr-head">
                    <tr class="tb-tnx-head">
                        <td class="tb-odr-info">Type</td>
                        <td class="tb-odr-info">Value</td>
                        <td class="tb-odr-action">Actions</td>
                    </tr>
                </thead>
                <tbody class="tb-odr-body"> 
                    {foreach $tipPresets as $tipPreset}
                        <tr class="tb-odr-item">
                            <td class="tb-odr-info">{$tipPreset.type|ucfirst}</td>
                            <td class="tb-odr-info fw-bold">
                                {if $tipPreset.type == "amount"}
                                    {formatPrice($tipPreset.value)}
                                {else}
                                    {$tipPreset.value}%
                                {/if}
                            </td>
                            <td class="tb-odr-action">
                                <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-sm btn-danger js_deleter" data-handle="tip-preset" data-id="{$tipPreset.id}">
                                    <i class="icon ni ni-trash"></i> <span>Delete</span>
                                </button>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>

            {if count($tipPresets) < 3}
                <button data-toggle="modal" data-url="#addTipPresetModal" data-size="small" class="btn btn-success">
                    <i class="icon ni ni-plus"></i> <span>Add Tip Preset</span>
                </button>
            {else}
                <span class="text-danger">You can only have a max of 3 presets</span>
            {/if}

        {else}
            <div class="text-center x-muted py-5">
                <em class="icon ni ni-tags icon-circle icon-circle-xxl bg-info mb-3"></em>
                <h6 class="text-muted mb-3 fw-normal">No presets to show</h6>
                <button data-toggle="modal" data-url="#addTipPresetModal" data-size="small" class="btn btn-success">
                    <i class="icon ni ni-plus"></i> <span>Add Tip Preset</span>
                </button>
            </div>
        {/if}
    </div>
    <div class="col-md-5 offset-md-1">
        <form class="js_ajax-forms form-horizontal" data-url="/{$module_name}/updateTipSettings">
            <div class="form-group">
                <label class="form-label">Writer Tip</label>
                <div class="form-control-wrap w-150px">
                    <div class="form-icon form-icon-right">
                        <em class="icon ni ni-percent"></em>
                    </div>
                    <input type="text" class="form-control form-control-lg force-integer" name="writer_percentage" value="{$tipConfiguration.TIP_WRITER_PERCENT}">
                </div>
                <span class="help-block">The percentage the writer will receive</span>
            </div>

            <div class="form-group">
                <label class="form-label">Editor Tip</label>
                <div class="form-control-wrap w-150px">
                    <div class="form-icon form-icon-right">
                        <em class="icon ni ni-percent"></em>
                    </div>
                    <input type="text" class="form-control form-control-lg force-integer" name="editor_percentage" value="{$tipConfiguration.TIP_EDITOR_PERCENT}">
                </div>
                <span class="help-block">The percentage the editor will receive</span>
            </div>

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>

            <button type="submit" class="btn btn-success pull-right">Save Changes</button>
        </div>
    </form>
</div>


<!-- Add Preset -->
<script id="addTipPresetModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/{$module_name}/addTipPreset" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Preset</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="ni ni-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group form-row">
                <label class="control-label text-left">Tip Type</label>
                <select class="form-select" data-ui="lg" name="tip_type" data-combo="tip_type">
                    <option value="amount"selected="">Amount</option>
                    <option value="percent" >Percent</option>
                </select>
            </div>

            <div id="tip_type">
                <div class="switch-combo" data-combo-value="amount">
                    <div class="form-group">
                        <label class="control-label text-left">Amount</label>
                        <input class="form-control form-control-lg force-integer" type="text" name="tip_amount">
                    </div>
                </div>

                <div class="switch-combo x-hidden" data-combo-value="percent">
                    <div class="form-group">
                        <label class="form-label">Percentage</label>
                        <div class="form-control-wrap">
                            <div class="form-icon form-icon-right">
                                <em class="icon ni ni-percent"></em>
                            </div>
                            <input type="text" class="form-control form-control-lg force-integer" name="tip_percent">
                        </div>
                    </div>
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Preset</button>
        </div>
    </form>
</script>
<!-- Add Preset -->