<div class="row">
    <div class="col-md-5">
        {if count($tipPresets)}

            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <td>Type</td>
                            <td>Value</td>
                            <td>Actions</td>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $tipPresets as $tipPreset}
                            <tr>
                                <td>{$tipPreset.type|ucfirst}</td>
                                <td>
                                    {if $tipPreset.type == "amount"}
                                        {formatPrice($tipPreset.value)}
                                    {else}
                                        {$tipPreset.value}%
                                    {/if}
                                </td>
                                <td>
                                    <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="tip-preset" data-id="{$tipPreset.id}">
                                        <i class="fa fa-trash-alt"></i>
                                    </button>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>

            {if count($tipPresets) < 3}
                <button data-toggle="modal" data-url="#addTipPresetModal" data-size="small" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> Add Tip Preset</button>
            {else}
                <span class="text-danger">You can only have a max of 3 presets</span>
            {/if}

        {else}
            <div class="text-center x-muted mt20 mb10"> 
                <i class="fa fa-tags fa-4x"></i>
                <p class="mb10"><strong>No presets to show</strong></p>
                <button data-toggle="modal" data-url="#addTipPresetModal" data-size="small" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> Add Tip Preset</button>
            </div>
        {/if}
    </div>
    <div class="col-md-6 offset-md-1">
        <form class="js_ajax-forms form-horizontal" data-url="/{$module_name}/updateTipSettings">
            <div class="form-group form-row">
                <label class="col-sm-4 control-label text-center">Writer Tip</label>
                <div class="col-sm-8">
                    <input class="form-control force-integereger" type="text" name="writer_percentage" value="{$tipConfiguration.TIP_WRITER_PERCENT}">
                    <span class="help-block">
                        The percentage the writer will receive
                    </span>
                </div>
            </div>

            <div class="form-group form-row">
                <label class="col-sm-4 control-label text-center">Editor Tip</label>
                <div class="col-sm-8">
                    <input class="form-control force-integereger" type="text" name="editor_percentage" value="{$tipConfiguration.TIP_EDITOR_PERCENT}">
                    <span class="help-block">
                        The percentage the editor will receive
                    </span>
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->

            <button type="submit" class="btn btn-success pull-right">Save Changes</button>
        </div>
    </form>
</div>


<!-- Add Preset -->
<script id="addTipPresetModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/{$module_name}/addTipPreset" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Preset</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group form-row">
                <label class="control-label text-left">Tip Type</label>
                <select class="form-control" name="tip_type" data-combo="tip_type">
                    <option value="amount"selected="">Amount</option>
                    <option value="percent" >Percent</option>
                </select>
            </div>

            <div id="tip_type">
                <div class="switch-combo" data-combo-value="amount">
                    <div class="form-group">
                        <label class="control-label text-left">Amount</label>
                        <input class="form-control force-integer" type="text" name="tip_amount">
                    </div>
                </div>

                <div class="switch-combo x-hidden" data-combo-value="percent">
                    <div class="form-group">
                        <label class="control-label text-left">Percentage</label>
                        <input class="form-control force-integer" type="text" name="tip_percent">
                    </div>
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Preset</button>
        </div>
    </form>
</script>
<!-- Add Preset -->