<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\ObjectModel;

class ConversationMessage extends ObjectModel
{
    /** @var $id ConversationMessage ID */
    public $id;

    /** @var int conversation_id */
    public $conversation_id;

    /** @var int user_id */
    public $user_id;

    /** @var string message */
    public $message;

    /** @var string image */
    public $image;

    /** @var string voice_note */
    public $voice_note;

    /** @var string date_upd */
    public $date_upd;

    /** @var string date_add */
    public $date_add;
    
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'conversation_message',
        'primary' => 'message_id',
        'fields' => array(
            'conversation_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'user_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'message' => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'image' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'size' => 256),
            'voice_note' => array('type' => self::TYPE_STRING, 'validate' => 'isString', 'size' => 256),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
        ),
    );

    public function __construct($id = null)
    {
        parent::__construct($id);
    }
}