<?php 
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\ObjectModel;

class ConversationUser extends ObjectModel
{
    /** @var $id ConversationUser ID */
    public $id;

    /** @var int conversation_id */
    public $conversation_id;

    /** @var int user_id */
    public $user_id;

    /** @var bool seen */
    public $seen = 0;

    /** @var bool typing */
    public $typing = 0;

    /** @var bool deleted */
    public $deleted = 0;

    /** @var string date_upd */
    public $date_upd;

    /** @var string date_add */
    public $date_add;
    
    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'conversation_user',
        'primary' => 'conversation_user_id',
        'fields' => array(
            'conversation_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'user_id' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'seen' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'typing' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'deleted' => array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
        ),
    );

    public function __construct($id = null)
    {
        parent::__construct($id);
    }
}