// guid
function guid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x150000).toString(16).substring(1);
    }
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' + s4() + '-' + s4() + s4() + s4();
}

// htmlEntities
function htmlEntities(str) {
    return String(str).replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
}

// is empty
function is_empty(value) {
    if (value.match(/\S/) == null) {
        return true;
    } else  {
        return false;
    }
}

// initialize chat global vars
var chatbox_closing_process = false;

// messenger heartbeat
function messenger_heartbeat() {
    /* check if there is any closing process */
    if(chatbox_closing_process) {
        setTimeout('messenger_heartbeat()', 15000);
        return;
    }

    /* prepare client opened chat boxes with its last messages */
    var chat_boxes_opened_client = {}; // we use "objects" because JS don't support user-indexed array ;)
    $.each($('.chat-box:not(.fresh)'), function(i,chat_box) {
        if(!$(chat_box).data('sending')) {
            chat_boxes_opened_client[$(chat_box).data('cid')] = $(chat_box).find('.conversation:last').attr('id'); // object = {"cid": "last_message", ....}
        }
    });

    /* check if messages page is opened & there is a loaded converstaion */
    if(window.location.pathname.indexOf("messenger") != -1 && $('.panel-messages').data('cid') !== undefined) {
        /* add the current loaded converstion */
        var opened_thread = {};
        if(!$('.panel-messages').data('sending')) {
            opened_thread['conversation_id'] = $('.panel-messages').data('cid');
            opened_thread['last_message_id'] = $('.panel-messages').find('.conversation:last').attr('id');
        }
        /* prepare data */
        var data = {'chat_boxes_opened_client': JSON.stringify(chat_boxes_opened_client), 'opened_thread': JSON.stringify(opened_thread)};
    } else {
        /* prepare data */
        var data = {'chat_boxes_opened_client': JSON.stringify(chat_boxes_opened_client)};
    }

    /* post to the server and get updates */
    $.post(`${proxim.api_path}/messenger/liveChat`, data, function(response) {
        if(response.callback) {
            eval(response.callback);
        } else {
            /* init updated seen conversations if any */
            var updated_seen_conversations = [];
            /* [1] [update] master chat sidebar (online & offline friends list) */
            /* [2] [update] master chat sidebar (online users counter & chat status) */
            if(response.master) {
                if($(".chat-sidebar-content").find("[data-tab='writers']").length) {
                    $(".chat-sidebar-content").find("[data-tab='writers']").find(".js_scroller").html(response.master.sidebar_writers);
                } else {
                    $(".chat-sidebar-content").find(".js_scroller").html(response.master.sidebar);
                }

                $('.chat-sidebar-filter').keyup();
            }

            /* [3] & [4] & [5] check if the user not in messages page */
            if(window.location.pathname.indexOf("messenger") == -1) {
                /* [3] [get] closed chat boxes */
                if(response.chat_boxes_closed !== undefined) {
                    $.each(response.chat_boxes_closed, function(i,conversation) {
                        $("#chat_"+conversation).remove();
                    });
                    /* reconstruct chat-widgets */
                    reconstruct_chat_widgets();
                }
                /* [4] [get] opened chat boxes */
                if(response.chat_boxes_opened) {
                    $.each(response.chat_boxes_opened, function(i,conversation) {
                        chat_box(conversation.user_id, conversation.conversation_id, conversation.name, conversation.name_list, conversation.multiple_recipients, conversation.link);
                    });
                }
                /* [5] [get] updated chat boxes */
                if(response.chat_boxes_updated) {
                    $.each(response.chat_boxes_updated, function(i,conversation) {
                        var chat_box_widget = $("#chat_"+conversation['conversation_id']);
                        /* [1] check for a new messages for this chat box */
                        if(conversation['messages']) {
                            chat_box_widget.find(".js_scroller:first ul").append(conversation['messages']);
                            chat_box_widget.find(".js_scroller:first").scrollTop(chat_box_widget.find(".js_scroller:first")[0].scrollHeight);
                            if(!conversation['is_me']) {
                                if(!chat_box_widget.hasClass("opened")) {
                                    chat_box_widget.addClass("new").find(".js_chat-box-label").text(conversation['messages_count']);
                                } else {
                                    /* update this convertaion seen status (if enabled by the system) */
                                    updated_seen_conversations.push(conversation['conversation_id']);
                                }
                                
                                if (notifications_sound && $("#chat_sound").length ) {
                                    $("#chat_sound")[0].play();
                                }
                            }
                        }
                        /* [2] check if any recipient typing */
                        if(conversation['typing_name_list']) {
                            chat_box_widget.find('.js_chat-typing-users').text(conversation['typing_name_list']);
                            chat_box_widget.find('.chat-typing').show();
                        } else {
                            chat_box_widget.find('.chat-typing').hide();
                        }
                        /* [3] check if any recipient seeing */
                        if(conversation['seen_name_list']) {
                            var last_message_box = chat_box_widget.find(".js_scroller:first li:last .conversation.right");
                            if(last_message_box.length > 0) {
                                if(last_message_box.find('.seen').length == 0) {
                                    /* add seen status */
                                    last_message_box.find('.time').after("<div class='seen'>Seen by "+conversation['seen_name_list']+"<div>");
                                    chat_box_widget.find(".js_scroller:first").scrollTop(chat_box_widget.find(".js_scroller:first")[0].scrollHeight);
                                } else {
                                    /* update seen status */
                                    last_message_box.find('.seen').replaceWith("<div class='seen'>Seen by "+conversation['seen_name_list']+"<div>");
                                }
                            }
                        }
                        /* [4] check single user's chat status (online|offline) */
                        if(!conversation['multiple_recipients']) {
                            /* update single user's chat status */
                            if(conversation['user_online']) {
                                chat_box_widget.find(".js_chat-box-status").removeClass("fa-user-secret").addClass("fa-circle");
                            } else {
                                chat_box_widget.find(".js_chat-box-status").removeClass("fa-circle").addClass("fa-user-secret");
                            }
                        }
                        /* update chat widget color */
                        color_chat_box(chat_box_widget, conversation['color']);
                    });
                }
                /* [6] [get] new chat boxes */
                if(response.chat_boxes_new) {
                    $.each(response.chat_boxes_new, function(i,conversation) {
                        chat_box(conversation.user_id, conversation.conversation_id, conversation.name, conversation.name_list, conversation.multiple_recipients, conversation.link);
                        if (notifications_sound && $("#chat_sound").length ) {
                            $("#chat_sound")[0].play();
                        }
                    });
                }
            }
            /* [7] [get] updated thread */
            if(response.thread_updated) {
                /* check if the user in messages page */
                if(window.location.pathname.indexOf("messenger") != -1) {
                    var converstaion_widget = $('.panel-messages[data-cid="'+response.thread_updated['conversation_id']+'"]');
                    if(converstaion_widget.length > 0) {
                        /* [1] check for a new messages for this chat box */
                        if(response.thread_updated['messages']) {
                            converstaion_widget.find(".js_scroller:first ul").append(response.thread_updated['messages']);
                            converstaion_widget.find(".js_scroller:first").scrollTop(converstaion_widget.find(".js_scroller:first")[0].scrollHeight);
                            if(!response.thread_updated['is_me']) {
                                /* update this convertaion seen status (if enabled by the system) */
                                updated_seen_conversations.push(response.thread_updated['conversation_id']);
                                if (notifications_sound && $("#chat_sound").length ) {
                                    $("#chat_sound")[0].play();
                                }
                            }
                        }
                        /* [2] check if any recipient typing */
                        if(response.thread_updated['typing_name_list']) {
                            converstaion_widget.find('.js_chat-typing-users').text(response.thread_updated['typing_name_list']);
                            converstaion_widget.find('.chat-typing').show();
                        } else {
                            converstaion_widget.find('.chat-typing').hide();
                        }
                        /* [3] check if any recipient seeing */
                        if(response.thread_updated['seen_name_list']) {
                            var last_message_box = converstaion_widget.find(".js_scroller:first li:last .conversation.right");
                            if(last_message_box.length > 0) {
                                if(last_message_box.find('.seen').length == 0) {
                                    /* add seen status */
                                    last_message_box.find('.time').after("<div class='seen'>Seen by "+response.thread_updated['seen_name_list']+"<div>");
                                    converstaion_widget.find(".js_scroller:first").scrollTop(converstaion_widget.find(".js_scroller:first")[0].scrollHeight);
                                } else {
                                    /* update seen status */
                                    last_message_box.find('.seen').replaceWith("<div class='seen'>Seen by "+response.thread_updated['seen_name_list']+"<div>");
                                }
                            }
                        }
                        /* update chat widget color */
                        color_chat_box(converstaion_widget, response.thread_updated['color']);
                    }   
                }
            }
            
            // update convertaion(s) seen status
            if(updated_seen_conversations.length > 0) {
                $.post(`${proxim.api_path}/messenger/chatReaction`, {'do': 'seen', 'ids': updated_seen_conversations}, function(response) {
                    if(response.callback) {
                        eval(response.callback);
                    }
                }, 'json');
            }
        }
        setTimeout('messenger_heartbeat()', 15000);
    }, 'json');
}

// reconstruct chat-widgets
function reconstruct_chat_widgets() {
    if($(window).width() < 970) {
        return;
    }
    $('.chat-widget').each(function(index) {
        $(this).attr('style', '');
        index += 1;
        offset = (index*210) + (index*10);
        if($(this).prevAll('.chat-box').length > 0) {
            offset += $(this).prevAll('.chat-box').length*50;
        }
        if($('html').attr('dir') == 'RTL') {
            $(this).css('left', offset);
        } else {
            $(this).css('right', offset);
        }
    });
}

// chat box
function chat_box(user_id, conversation_id, name, name_list, multiple, link) {
    /* open the #chat_key */
    var chat_key_value = 'chat_';
    chat_key_value += (conversation_id)? conversation_id : 'u_'+user_id;
    var chat_key = '#' + chat_key_value;
    var chat_box = $(chat_key);
    /* check if this chat_box already exists */
    if(chat_box.length == 0) {
        /* check if conversation_id is set */
        if(conversation_id == false) {
            var data = {'user_id': user_id};
            if($('.chat-box[data-uid="'+user_id+'"]').length > 0) {
                /* select the opened one */
                chat_box = $('.chat-box[data-uid="'+user_id+'"]');
                /* open chat-box with that chat_key that already exists if not opened */
                if(!chat_box.hasClass('opened')) {
                    chat_box.addClass('opened').find('.chat-widget-content').slideToggle(200);
                }
                return;
            } else {
                /* construct a new one */
                $('body').append(render_template('#chat-box', {'chat_key_value': chat_key_value, 'user_id': user_id, 'conversation_id': conversation_id, 'name': name.substring(0,28), 'name_list': name_list, 'multiple': multiple, 'link': link}));
                chat_box = $(chat_key);
                chat_box.find('.chat-widget-content').show();
                chat_box.find('textarea').focus();
                /* initialize the plugins */
                initialize();
                /* reconstruct chat-widgets */
                reconstruct_chat_widgets();
            }
        } else {
            var data = {'conversation_id': conversation_id};
            /* construct a new one */
            $('body').append(render_template('#chat-box', {'chat_key_value': chat_key_value, 'user_id': user_id, 'conversation_id': conversation_id, 'name': name.substring(0,28), 'name_list': name_list, 'multiple': multiple, 'link': link}));
            chat_box = $(chat_key);
            chat_box.find('.chat-widget-content').show();
            chat_box.find('textarea').focus();
            /* initialize the plugins */
            initialize();
            /* reconstruct chat-widgets */
            reconstruct_chat_widgets();
        }
        /* get conversation messages */
        $.getJSON( `${proxim.base_uri}/messenger/chatMessages`, data, function(response) {
            /* check the response */
            if(!response) return;
            if(response.callback) {
                eval(response.callback);
                /* remove the chat-box */
                chat_box.remove();
            } else {
                if(response.conversation_id) {
                    if($('#chat_'+response.conversation_id).length > 0) {
                        /* remove the new chat-box */
                        chat_box.remove();
                        /* select the opened one */
                        chat_box = $('#chat_'+response.conversation_id);
                        /* open chat-box with that chat_key that already exists if not opened */
                        if(!chat_box.hasClass('opened')) {
                            chat_box.addClass('opened').find('.chat-widget-content').slideToggle(200);
                        }
                        chat_box.find('textarea').focus();
                        return;
                    } else {
                        chat_box.attr("id", 'chat_'+response.conversation_id);
                        chat_box.attr("data-cid", response.conversation_id);
                    }
                    chat_box.find('.x-form-tools-colors').show();
                }
                if(response.user_online !== undefined && response.user_online) {
                    chat_box.find(".js_chat-box-status").removeClass("fa-user-secret").addClass("fa-circle");
                }
                if(response.messages) {
                    chat_box.find(".js_scroller:first").html(response.messages).scrollTop(chat_box.find(".js_scroller:first")[0].scrollHeight);
                }
                if(response.color) {
                    chat_box.attr("data-color", response.color);
                    color_chat_box(chat_box, response.color);
                }
            }
        })
        .fail(function() {
            /* remove the chat-box */
            chat_box.remove();
            modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
        });
    } else {
        /* open chat-box with that chat_key that already exists if not opened */
        if(!chat_box.hasClass('opened')) {
            chat_box.addClass('opened').find('.chat-widget-content').slideToggle(200);
        }
        chat_box.find('textarea').focus();
        /* reconstruct chat-widgets */
        reconstruct_chat_widgets();
    }
}

// color chat box
function color_chat_box(chat_widget, color) {
    chat_widget.data('color', color);
    chat_widget.find('.js_chat-color-me').each(function() {
        if($(this).hasClass("js_chat-colors-menu-toggle")) {
            $(this).css("color", color);
        } else {
            $(this).css("background-color", color);
        }
    });
}


$(function () {

    // start chat heartbeat
    setTimeout('messenger_heartbeat()', 15000);

    // chat-box
    $(document).on('click', '.js_chat-new', function(e) {
        e.stopPropagation();

        /* check if chat disabled or opened from mobile */
        if($(window).width() < 970) { // Desktops (≥992px)
            /* chat dissabled or mobile view */
            return;
        } else {
            /* desktop view */
            e.preventDefault();
            /* open fresh chat-box */
            /* check if there is any fresh chat-box already exists */
            if($('.chat-box.fresh').length == 0) {
                /* construct a new one */
                $('body').append(render_template('#chat-box-new'));
                $('.chat-box.fresh').find('.chat-widget-content').show();
                /* initialize the main plugins */
                initialize();
                /* reconstruct chat-widgets */
                reconstruct_chat_widgets();
            } else {
                /* open fresh chat-box that already exists if not opened */
                if(!$('.chat-box.fresh').hasClass('opened')) {
                    $('.chat-box.fresh').addClass('opened');
                    $('.chat-box.fresh').find('.chat-widget-content').slideToggle(200);
                }
            }
        }
    });

    $(document).on('click', '.js_chat-start', function(e) {
        /* get data from (header conversation feeds || chat sidebar) */
        /* mandatory */
        var user_id = $(this).data('uid') || false;
        var conversation_id = $(this).data('cid') || false;
        /* optional */
        var name = $(this).data('name');
        var name_list = $(this).data('name-list') || name;
        var multiple = ($(this).data('multiple'))? true: false;
        var link = $(this).data('link');
        /* load previous conversation */
        /* check if the viewer in the messages page & open already conversation */
        if(window.location.pathname.indexOf("messenger") != -1 && conversation_id) {
            e.preventDefault();
            $(".js_conversation-container").html('<div class="loader loader_medium pr10"></div>');
            $.getJSON( `${proxim.base_uri}/messenger/conversation`, {'conversation_id': conversation_id}, function(response) {
                /* check the response */
                if(response.callback) {
                    eval(response.callback);
                } else {
                    $(".js_conversation-container").html(response.conversation_html);
                    $('.panel-messages').attr("data-color", response.conversation.color);
                    color_chat_box($('.panel-messages'), response.conversation.color);
                }
            })
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        } else {
            /* check if chat is opened from mobile */
            if($(window).width() < 970) { // Desktops (≥992px)
                /* chat dissabled or mobile view */
                if(conversation_id) {
                    /* conversation_id is set so return (return will allow default behave of anchor tag) */
                    return;
                } else {
                    e.preventDefault();
                    $.getJSON( `${proxim.base_uri}/messenger/checkConversation`, {'uid': user_id}, function(response) {
                        /* check the response */
                        if(!response) return;
                        if(response.callback) {
                            eval(response.callback);
                        } else {
                            if(response.conversation_id) {
                                window.location = proxim.base_uri + "/messenger/" + response.conversation_id;
                            } else {
                                window.location = proxim.base_uri + "/messenger/new?uid="+user_id;
                            }
                        }
                    })
                    .fail(function() {
                        modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
                    });
                }
            } else {
                /* desktop view */
                e.preventDefault();
                /* load chat-box */
                chat_box(user_id, conversation_id, name, name_list, multiple, link);
            }
        }
    });

    // post message
    /* post message */
    function _post_message(element) {
        var _this = $(element);
        var widget = _this.parents('.chat-widget, .panel-messages');
        var textarea = widget.find('textarea.js_post-message');
        var message = textarea.val();
        var conversation_id = widget.data('cid');
        var attachments = widget.find('.chat-attachments');
        /* get photo from widget data */
        var photo = widget.data('photo');
        /* check if message is empty */
        if(is_empty(message) && !photo) {
            return;
        }
        /* check if posting the message to (new || existed) conversation */
        if(widget.hasClass('fresh')) {
            /* post the message to -> a new conversation */
            /* check recipients */
            if(widget.find('.tags li').length == 0) {
                return;
            }
            /* get recipients */
            var recipients = [];
            $.each(widget.find('.tags li'), function(i,tag) {
                recipients.push($(tag).data('uid'));
            });
            var data = {'message': message, 'photo': JSON.stringify(photo), 'recipients': JSON.stringify(recipients)};
        } else {
            if(conversation_id === undefined) {
                /* post the message to -> a new conversation */
                /* get recipients */
                var recipients = [];
                recipients.push(widget.data('uid'));
                var data = {'message': message, 'photo': JSON.stringify(photo), 'recipients': JSON.stringify(recipients)};
            } else {
                /* post the message to -> already existed conversation */
                var data = {'message': message, 'photo': JSON.stringify(photo), 'conversation_id': conversation_id};
            }
        }
        /* add the message directly if widget not fresh & not sending photo */
        if(!widget.hasClass('fresh') && photo === undefined) {
            textarea.focus().val('').height(textarea.css('line-height'));
            var _guid = guid()
            widget.find(".js_scroller:first ul").append(render_template('#chat-message', {'message': htmlEntities(message), 'id': _guid, 'time': moment.utc().format("YYYY-MM-DD H:mm:ss")}));
            widget.find(".js_scroller:first .seen").remove(); // remove any seen status before
            widget.find(".js_scroller:first").scrollTop(widget.find(".js_scroller:first")[0].scrollHeight);
        } else {
            /* widget is fresh or sending photo */
            /* check if there is current (sending) process */
            if(widget.data('sending')) {
                return false;
            }
        }
        /* add currenet sending process */
        widget.data('sending', true);
        /* process */
        $.post(`${proxim.api_path}/messenger/postChat`, data, function(response) {
            /* check the response */
            if(!response) return;
            /* check if there is a callback */
            if(response.callback) {
                eval(response.callback);
            } else {
                if(widget.hasClass('fresh')) {
                    if(window.location.pathname.indexOf("messages") != -1) {
                        /* in messages page */
                        window.location.replace( `${proxim.base_uri}/messenger?cid=${response.conversation_id}`);
                    } else {
                        widget.remove();
                        chat_box(response.user_id, response.conversation_id, response.name, response.name_list, response.multiple_recipients, response.link);
                    }
                } else {
                    if(conversation_id === undefined) {
                        widget.attr("id", "chat_"+response.conversation_id);
                        widget.attr("data-cid", response.conversation_id);
                        widget.find('.x-form-tools-colors').show();
                    }
                    
                    if(photo === undefined) {
                        widget.find(".js_scroller:first ul").find("#"+_guid).replaceWith(render_template('#chat-message', {'message': response.message, 'image': response.image, 'id': response.last_message_id, 'time': moment.utc().format("YYYY-MM-DD H:mm:ss"), 'color': widget.data('color')}));
                    } else {
                        textarea.focus().val('').height(textarea.css('line-height'));
                        widget.find(".js_scroller:first ul").append(render_template('#chat-message', {'message': response.message, 'image': response.image, 'id': response.last_message_id, 'time': moment.utc().format("YYYY-MM-DD H:mm:ss"), 'color': widget.data('color')}));
                        widget.find(".js_scroller:first .seen").remove(); // remove any seen status before
                        widget.find(".js_scroller:first").scrollTop(widget.find(".js_scroller:first")[0].scrollHeight);
                        /* handle attachments */
                        attachments.hide();
                        attachments.find('li.item').remove();
                        widget.removeData('photo');
                        widget.find('.x-form-tools-attach').show();
                    }
                    /* remove currenet sending process */
                    widget.removeData('sending');
                }
            }
        }, 'json')
        .fail(function() {
            modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
        });
    }

    $(document).on('keydown', 'textarea.js_post-message', function (event) {
        if($(window).width() >= 970 && (event.keyCode == 13 && event.shiftKey == 0)) {
            event.preventDefault();
            _post_message(this);
        }
    });

    $(document).on('click', 'li.js_post-message', function (event) {
        if($(window).width() < 970) {
            _post_message(this);
        }
    });

    /* chat attachment remover */
    $(document).on('click', '.js_chat-attachment-remover', function() {
        var widget = $(this).parents('.chat-widget, .panel-messages');
        var attachments = widget.find('.chat-attachments');
        var item = $(this).parents('li.item');
        /* remove the attachment from widget data */
        widget.removeData('photo')
        /* remove the attachment item */
        item.remove();
        /* hide attachments */
        attachments.hide();
        /* show widget form tools */
        widget.find('.x-form-tools-attach').show();
        widget.find('.x-form-tools-voice').show();
    });


    // chat typing status
    var chat_typing_timer;
    // it's 01/01/1970, actually some time in the past
    var last_typed_time = new Date(0);
    // how long user can "think about his spelling" before we show "No one is typing -blank space." message
    var typing_delay_millis = 5000; 

    $(document).on('keyup paste change input propertychange', 'textarea.js_post-message', function() {
        var _this = $(this);
        var widget = _this.parents('.chat-widget, .panel-messages');
        var conversation_id = widget.data('cid') || false;
        last_typed_time = new Date();

        if(!conversation_id) {
            return;
        }

        clearTimeout(chat_typing_timer);

        /* check if there is current (sending) process */
        if(widget.data('sending')) {
            return;
        }

        chat_typing_timer = setTimeout(function() {
            var is_typing = 1;
            if ( !_this.is(':focus') || _this.val() == '' || new Date().getTime() - last_typed_time.getTime() > typing_delay_millis) {
                is_typing = 0;
            } else {
                is_typing = 1;
            }
            
            $.post(`${proxim.api_path}/messenger/chatReaction`, {'do': 'typing', 'is_typing': is_typing, 'conversation_id': conversation_id}, function(response) {
                if(response.callback) {
                    eval(response.callback);
                }
            }, 'json');
        }, 500);
    });


    // toggle chat-widget
    $(document).on('click', '.chat-widget-head', function(e) {
        /* check if user just starting video/audio call */
        if($(e.target).hasClass('js_chat-call-start')) {
           return;
       }
        var widget = $(this).parents('.chat-widget');
        var conversation_id = widget.data('cid') || false;
        /* toggle 'opened' class */
        widget.toggleClass('opened');
        /* toggle widget content */
        widget.find('.chat-widget-content').slideToggle(200);
        /* scroll to latest message if has class new (new = there is new messages not seen) */
        if(widget.hasClass('new')) {
            widget.find(".js_scroller:first").scrollTop(widget.find(".js_scroller:first")[0].scrollHeight);
            widget.removeClass('new');
            /* update this convertaion seen status (if enabled by the system) */
            if(conversation_id) {
                $.post(`${proxim.api_path}/messenger/chatReaction`, {'do': 'seen', 'ids': conversation_id}, function(response) {
                    if(response.callback) {
                        eval(response.callback);
                    }
                }, 'json');
            }
        }
    });

    // close chat-widget
    $(document).on('click', '.js_chat-box-close', function() {
        var widget = $(this).parents('.chat-widget');
        widget.remove();
        /* reconstruct chat-widgets */
        reconstruct_chat_widgets();
        /* update chatbox closing process */
        chatbox_closing_process = true;
        /* unset from session */
        if(widget.data('cid') !== undefined) {
            $.post(`${proxim.api_path}/messenger/chatReaction`, {'do': 'close', 'conversation_id': widget.data('cid')}, function(response) {
                if(response.callback) {
                    eval(response.callback);
                }
                /* update chatbox closing process */
                chatbox_closing_process = false;
            }, 'json')
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        }
    });


    // reconstruct chat widgets when resize window
    $(window).bind("resize", function() {
        reconstruct_chat_widgets();
    });

    /* color panel messages (messages page) */
    if(window.location.pathname.indexOf("messenger") != -1 && $('.panel-messages').data('cid') !== undefined) {
        color_chat_box($('.panel-messages'), $('.panel-messages').attr("data-color"));
    }

    /* toggle(close|open) colors-menu */
    $(document).on('click', '.js_chat-colors-menu-toggle', function() {
        if($(this).parent().find('.chat-colors-menu').length == 0) {
            $(this).after(render_template("#chat-colors-menu"));
        }
        $(this).parent().find('.chat-colors-menu').toggle();
    });
    
    /* close chat-colors-menu when clicked outside */
    $(document).on('click', function(e) {
        if($(e.target).hasClass('js_chat-colors-menu-toggle') || $(e.target).parents('.js_chat-colors-menu-toggle').length > 0 || $(e.target).hasClass('chat-colors-menu') || $(e.target).parents('.chat-colors-menu').length > 0) {
           return;
       }
       $('.chat-colors-menu').hide();
    });

    /* change chat color */
    $(document).on('click', '.js_chat-color', function() {
        var chat_widget = $(this).parents('.chat-widget, .panel-messages');
        var conversation_id = chat_widget.data('cid');
        var color = $(this).data('color');
        color_chat_box(chat_widget, color);
        $('.chat-colors-menu').hide();
        $.post( `${proxim.api_path}/messenger/chatReaction`, {'do': 'color', 'conversation_id': conversation_id, 'color': color}, function(response) {
            if(response.callback) {
                eval(response.callback);
            }
        }, 'json')
        .fail(function() {
            modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
        });
    });

    proxim.eventEmitter.on('actionBeforeXUploader', function(params) {
        var chat_widget = params._this.parents('.chat-widget, .panel-messages');
        /* check if there is already uploading process */
        if(chat_widget.data('photo')) {
            return false;
        }
        var attachments = chat_widget.find('.chat-attachments');
        var loader = attachments.find('li.loading');
        attachments.show();
        loader.show();
        /* hide chat widget x-form-tools */
        chat_widget.find('.x-form-tools-attach').hide();
        chat_widget.find('.x-form-tools-voice').hide();
    });

    proxim.eventEmitter.on('actionAfterXUploader', function(params) {
        var response = params.response;
        var chat_widget = params._this.parents('.chat-widget, .panel-messages');
        var attachments = chat_widget.find('.chat-attachments');

        var loader = attachments.find('li.loading');
        if(loader) loader.hide();

        /* add the attachment to chat widget data */
        chat_widget.data('photo', response.file);
        /* hide chat widget x-form-tools */
        chat_widget.find('.x-form-tools-attach').hide();
        chat_widget.find('.x-form-tools-voice').hide();
        /* add chat-attachments */
        var image_path = proxim.uploads_path+'/'+response.file;

        attachments.find('ul').append(render_template("#chat-attachments-item", {'src':response.file, 'image_path': image_path}));
    });

    proxim.eventEmitter.on('actionAfterDataHeartBeat', function(response) {
        if(response.conversations) {
            $(".js_live-messenger").find(".js_scroller").html("<ul>"+response.conversations+"</ul>");
            /* update live messages in messages page */
            if(window.location.pathname.indexOf("messenger") != -1) {
                if($(".js_live-messenger-alt").find(".js_scroller ul").length > 0) {
                    $(".js_live-messenger-alt").find(".js_scroller ul").html(response.conversations);
                } else {
                    $(".js_live-messenger-alt").find(".js_scroller").html("<ul>"+response.conversations+"</ul>");
                }
            }
            if(response.conversations_count > 0) {
                $(".js_live-messenger").find("span.counter").text(response.conversations_count).show();
                if (notifications_sound && $("#chat_sound").length ) {
                    $("#chat_sound")[0].play();
                }
            } else {
                $(".js_live-messenger").find("span.counter").text(response.conversations_count);
            }
        }
    });

    /* open the lightbox with no data */
    $(document).on('click', '.js_lightbox-nodata', function(e) {
        e.preventDefault();
        /* initialize vars */
        var image = $(this).data('image');
        /* load lightbox */
        var lightbox = $(render_template("#lightbox-nodata", {'image': image}));
        $('body').addClass('lightbox-open').append(lightbox.fadeIn('fast'));
    });

     /* close the lightbox (when click outside the lightbox content) */
     $(document).on('click', '.lightbox', function(e) {
        if($(e.target).is(".lightbox") || $(e.target).is(".lightbox-preview") ) {
            $('body').removeClass('lightbox-open');
            $('.lightbox').remove();
        }
    });

    // delete conversation
    $(document).on('click', '.js_delete-conversation', function() {
        confirm('Delete Conversation', 'Are you sure you want to delete this conversation?', function() {
            $.post(`${proxim.api_path}/messenger/chatReaction`, {'do': 'delete', 'conversation_id': $('.panel-messages').data('cid')}, function(response) {
                if(response.callback) {
                    eval(response.callback);
                }
            }, 'json')
            .fail(function() {
                modal('#modal-message', {title: 'Error', message: 'There is something that went wrong!'});
            });
        });
    });
});