{if $conversation['total_messages'] >= $max_results_limit}
	<!-- see-more -->
	<div class="text-center pt5 pb5 see-more small js_see-more" data-id={$conversation.conversation_id}  data-get="messages">
	    <span>Loading Older Messages</span>
	    <div class="loader loader_small x-hidden"></div>
	</div>
	<!-- see-more -->
{/if}

<ul>
    {foreach $conversation.messages as $message}
        <li>
            <div class="conversation clearfix {if $message.employee_id == $user.id}right{/if}" id="{$message.message_id}">
                {if $message.employee_id != $user.id}
                    <div class="conversation-user">
                        <img src="{$message.avatar}" alt="{$message.employee_id}">
                    </div>
                {/if}
                <div class="conversation-body">
                    <!-- message text -->
                    <div class="text {if $message.employee_id == $user.id}js_chat-color-me{/if}">
                        {$message.message}
                        {if $message.image}
                            <span class="text-link js_lightbox-nodata {if $message.message != ''}mt5{/if}" data-image="{$uploads_path}/{$message.image}">
                                <img alt="" class="img-fluid" src="{$uploads_path}/{$message.image}">
                            </span>
                        {/if}
                        {if $message.voice_note}
                            <audio class="js_audio" id="audio-{$message.message_id}" controls preload="auto" style="width: 100%; min-width: 120px;">
                                <source src="{$uploads_path}/{$message.voice_note}" type="audio/mpeg">
                                <source src="{$uploads_path}/{$message.voice_note}" type="audio/mp3">
                                Your browser does not support HTML5 audio
                            </audio>
                        {/if}
                    </div>
                    <!-- message text -->

                    <!-- message time -->
                    <div class="time js_moment" data-time="{$message.date_add}">{$message.date_add}</div>
                    <!-- message time -->

                    <!-- seen status -->
                    {if isset($last_seen_message_id) && ($last_seen_message_id == $message.message_id)}
                        <div class="seen">Seen by {$conversation.seen_name_list}</div>
                    {/if}
                    <!-- seen status -->
                </div>
            </div>
        </li>
    {/foreach}
</ul>