<div class="row">

<!-- threads -->
<div class="col-md-5 col-lg-4 offcanvas-sidebar">
    <div class="card mb0 h100">
        <div class="card-header with-icon bg-transparent pb10 pt10 lh30">
            {if $user.is_admin || $user.is_sub_admin}
                <div class="pull-right">
                    <a class="js_chat-new" href="{$base_uri}/messenger?new">
                        <i class="fas fa-edit fa-lg"></i>
                    </a>
                </div>
            {/if}
            Messenger
        </div>
        <div class="card-body pt10 pb10 pl0 pr0 js_live-messenger-alt">
            <div class="js_scroller" data-slimScroll-height="490px">
                <ul>
                    {foreach $conversations as $_conversation}
                        {include file=$conversation_tpl_path conversation=$_conversation}
                    {/foreach}
                </ul>

                {if count($conversations) >= $max_results_limit}
                    <!-- see-more -->
                    <div class="text-center pt5 pb5 see-more small ml5 mr5 js_see-more" data-get="conversations">
                        <span>Load Older Threads</span>
                        <div class="loader loader_small x-hidden"></div>
                    </div>
                    <!-- see-more -->
                {/if}
            </div>
        </div>
    </div>
</div>
<!-- threads -->

<!-- conversation -->
<div class="col-md-7 col-lg-8 offcanvas-mainbar js_conversation-container">
    {if $sub_view == "new"}
        <div class="card panel-messages fresh mb0 h100">
            <div class="card-header with-icon bg-transparent lh30 pt10 pb10">New Message</div>
            <div class="card-body">
                <div class="chat-conversations js_scroller" data-slimScroll-height="440px">
                </div>
                <div class="chat-to clearfix js_autocomplete-tags">
                    <div class="to">To:</div>
                    <ul class="tags">
                        {if isset($recipient)}
                            <li data-uid="{$recipient.employee_id}">{$recipient.name}<button type="button" class="close js_tag-remove" title="Remove"><span>×</span></button></li>
                        {/if}
                    </ul>
                    <div class="typeahead">
                        <input type="text" size="1" autofocus data-type="employee">
                    </div>
                </div>
                <div class="chat-attachments attachments clearfix x-hidden">
                    <ul>
                        <li class="loading">
                            <div class="progress x-progress"><div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100"></div></div>
                        </li>
                    </ul>
                </div>
                <div class="x-form chat-form">
                    <div class="chat-form-message">
                        <textarea class="js_autosize js_post-message" dir="auto" rows="1" placeholder='Write a message'></textarea>
                    </div>
                    <ul class="x-form-tools clearfix">
                        <li class="x-form-tools-attach">
                            <i class="fa fa-image fa-lg fa-fw js_x-uploader" data-handle="chat"></i>
                        </li>
                        <li class="x-form-tools-post js_post-message">
                            <i class="fa fa-paper-plane fa-lg fa-fw"></i>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    {else}
        {if isset($conversation)}
            {include file=$chat_conversation_tpl_path}
        {else}
            <div class="card card-messages mb0 h100" style="padding-top: 50px;">
                <div class="card-body text-center text-muted" style="min-height: 440px;">
                    <img class="mb20" width="30%" src="{$theme_uri}/images/no_results.png">
                    <p class="mt10 mb0"><strong>No Conversation Selected</strong></p>
                    {if $user.is_admin || $user.is_sub_admin}
                        <a class="mt20 btn btn-sm rounded-pill btn-primary js_chat-new" href="{$base_uri}/messenger?new">
                            <i class="fas fa-edit mr5"></i> New Message
                        </a>
                    {/if}
                </div>
            </div>
        {/if}
    {/if}
</div>
<!-- conversation -->