<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

use Proxim\ObjectModel;

/**
 * News
 */
class NewsObject extends ObjectModel
{
    const START_NEWS_ID = 12001;

    /** @var $id News ID */
    public $id;

    /** @var string title */
    public $title;

    /** @var string content */
    public $content;

    /** @var string recipient */
    public $recipient = 0;

    /** @var int views */
    public $views = 0;

    /** @var string date_upd */
    public $date_upd;

    /** @var string date_add */
    public $date_add;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'news',
        'primary' => 'news_id',
        'fields' => array(
            'title' => array('type' => self::TYPE_STRING, 'required' => true),
            'content' => array('type' => self::TYPE_HTML, 'required' => true),
            'recipient' => array('type' => self::TYPE_STRING, 'required' => true),
            'views' => array('type' => self::TYPE_INT, 'validate' => 'isInt'),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateOrNull'),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDate'),
        )
    );
    
    /**
     * constructor.
     *
     * @param null $id
     */
    public function __construct($id = null)
    {
        parent::__construct($id);
    }

    public function add($autodate = true, $null_values = true) {
		if ( !$this->getNextNewsId() ) {
			$this->id = self::START_NEWS_ID;
		} else {
			$next_news_id = Db::getInstance()->getValue('SELECT MAX(`news_id`)+2 FROM ' . Db::prefix('news'));
			$this->id = $next_news_id;
        }

		$this->force_id = true;

		return parent::add($autodate, $null_values);
    }

    public function delete() {
        $success = parent::delete();
        Db::getInstance()->delete('news_view', 'news_id = ' . (int) $this->id );
    }
    
    /**
     * This method return the ID of the previous news.
     *
     * @since 1.5.0.1
     *
     * @return int
     */
    public function getPreviousNewsId()
    {
        return Db::getInstance()->getValue('
            SELECT news_id
            FROM ' . DB_PREFIX . 'news
			WHERE news_id < ' . (int) $this->id . '
            ORDER BY news_id DESC');
    }
	
	/**
     * This method return the ID of the next news.
     *
     * @since 1.0.0
     *
     * @return int
     */
    public function getNextNewsId()
    {
        return Db::getInstance()->getValue('
            SELECT news_id
            FROM ' . DB_PREFIX . 'news
			WHERE news_id > ' . (int) $this->id . '
            ORDER BY news_id ASC');
    }
}