$(function () {
    proxim.eventEmitter.on('actionAfterDataHeartBeat', function(response) {
        if (response.master) {
            // writers
            $(".chat-sidebar-content").find("[data-tab='writers']").find(".js_scroller").html(response.master.sidebar_writers);
            // customers
            $(".chat-sidebar-content").find("[data-tab='customers']").find(".js_scroller").html(response.master.sidebar_customers);
        } 
    });

    // search user contacts
    $(document).on('keyup', '.js_chat-search', function(event) {
        var search = $(this).val().toLowerCase();
        $('.chat-sidebar-content .tab-pane.active ul > li').each(function() {
            var item  = $(this).text().toLowerCase();
            (item.indexOf( search ) != -1) ? $(this).show() : $(this).hide();
        });
    });

    // toggle chat-sidebar
    $(document).on('click', '.chat-sidebar-header', function(e) {
        var widget = $(this).parents('.chat-sidebar');
        var closed = widget.hasClass('closed') ? 1 : 0;
        /* toggle 'closed' class */
        widget.toggleClass('closed');

        $.post(`${proxim.api_path}/messenger/toggleChatHeader`, {'closed': closed}, function(response) {
            if(response.callback) {
                eval(response.callback);
            }
        }, 'json');
    });
});