{if $user.is_admin || $user.is_sub_admin}

    <div class="row mb20">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-primary">
                <div class="stat-cell">
                    <i class="fa fa-users bg-icon"></i>
                    <span class="text-xlg">{$insights['customers']}</span><br>
                    <span class="text-lg">Customers</span><br>
                    <a href="{$base_uri}/customers">Manage Customers</a>
                </div>
            </div>
        </div>
        
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-warning">
                <div class="stat-cell">
                    <i class="fa fa-users bg-icon"></i>
                    <span class="text-xlg">{$insights['employees']}</span><br>
                    <span class="text-lg">Employees</span><br>
                    <a href="{$base_uri}/employees/writers">Manage Employees</a>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-success">
                <div class="stat-cell">
                    <i class="fa fa-tasks bg-icon"></i>
                    <span class="text-xlg">{$insights['orders']}</span><br>
                    <span class="text-lg">Orders</span><br>
                    <a href="{$base_uri}/orders">Manage Orders</a>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-info">
                <div class="stat-cell">
                    <i class="fab fa-paypal bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights['customer_payments'])}</span><br>
                    <span class="text-lg">Total Sales</span><br>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-indigo">
                <div class="stat-cell">
                    <i class="fas fa-money-bill-wave bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights['writer_payments'])}</span><br>
                    <span class="text-lg">Writer Payments</span><br>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-red">
                <div class="stat-cell">
                    <i class="fas fa-money-bill-wave bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights['editor_payments'])}</span><br>
                    <span class="text-lg">Editor Payments</span><br>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-6">
            <div id="admin-chart-orders" class="admin-chart"></div>
        </div>
        <div class="col-sm-6">
            <div id="admin-chart-customers" class="admin-chart"></div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-6">
            <div id="admin-chart-sales" class="admin-chart"></div>
        </div>
        <div class="col-sm-6">
            <div id="admin-chart-payments" class="admin-chart"></div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-6">
            <h4 class="mt20">Top Customers</h4>
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th>Total Orders</th>
                            <th>Total Spent</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $insights['top_customers'] as $customer}
                            <tr>
                                <td><a href="/customers/edit/{$customer.customer_id}">{$customer.email}</a></td>
                                <td>{$customer.c_total_orders}</td>
                                <td>{formatPrice($customer.c_total_spent)}</td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-sm-6">
            <h4 class="mt20">Top Disciplines</h4>
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <th>{if $article_writing_enabled}Category{else}Discipline{/if}</th>
                            <th>Total Orders</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $insights['top_disciplines'] as $discipline}
                            <tr>
                                <td>{$discipline.title}</td>
                                <td>{$discipline.discipline_count}</td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
{/if}

{if $user.is_writer || $user.is_editor}
    <div class="row mb20">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-primary">
                <div class="stat-cell">
                    <i class="fas fa-money-check-alt bg-icon"></i>
                    <span class="text-xlg">{formatPrice($outstanding_payment)}</span><br>
                    <span class="text-lg">Outstanding Payment</span><br>
                    <a href="{$base_uri}/financial-overview/unrequested">Payment Overview</a>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-warning">
                <div class="stat-cell">
                    <i class="fab fa-paypal bg-icon"></i>
                    <span class="text-xlg">{formatPrice($last_pay)}</span><br>
                    <span class="text-lg">Last Pay</span><br>
                    <a href="{$base_uri}/financial-overview/history">Payment History</a>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-success">
                <div class="stat-cell">
                    <i class="fas fa-money-bill-wave bg-icon"></i>
                    <span class="text-xlg">{formatPrice($total_paid)}</span><br>
                    <span class="text-lg">Total Earned</span><br>
                    <a href="{$base_uri}/financial-overview/history">Payment History</a>
                </div>
            </div>
        </div>
    </div>

    <div id="admin-chart-income" class="admin-chart"></div>
{/if}

<!-- Admin Charts -->
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>

<script type="text/javascript">
    var xAxis = {
        categories: [
            "Jan",
            "Feb",
            "Mar",
            "Apr",
            "May",
            "Jun",
            "Jul",
            "Aug",
            "Sep",
            "Oct",
            "Nov",
            "Dec"
        ],
        crosshair: true
    };

    var yAxis = {
        min: 0,
        title: {
            text: "{'Y'|date}"
        }
    };

    var tooltip = {
        headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
        pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
            '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
        footerFormat: '</table>',
        shared: true,
        useHTML: true
    };

    var plotOptions = {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    };
</script>

{if $user.is_admin || $user.is_sub_admin}
    <script type="text/javascript">
        $(function () {
            $('#admin-chart-orders').highcharts({
                chart: {
                    type: 'column'
                },
                title: {
                    text: "Monthly Orders Average"
                },
                xAxis,
                yAxis,
                tooltip,
                plotOptions,
                series: [{
                    name: "Orders",
                    data: [{','|implode:$chart['orders']}]
                }]
            });

            $('#admin-chart-customers').highcharts({
                chart: {
                    type: 'column'
                },
                title: {
                    text: "Monthly Customers Average"
                },
                xAxis,
                yAxis,
                tooltip,
                plotOptions,
                series: [{
                    name: "Customers",
                    data: [{','|implode:$chart['customers']}]
                }]
            });

            $('#admin-chart-sales').highcharts({
                chart: {
                    type: 'line'
                },
                title: {
                    text: "Monthly Sales"
                },
                xAxis,
                yAxis,
                tooltip : {
                    headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                    pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                        '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions,
                series: [{
                    name: "Sales",
                    data: [{','|implode:$chart['sales']}]
                }]
            });

            $('#admin-chart-payments').highcharts({
                chart: {
                    type: 'line'
                },
                title: {
                    text: "Monthly Payments"
                },
                xAxis,
                yAxis,
                tooltip : {
                    headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                    pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                        '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions,
                series: [{
                    name: "Payments",
                    data: [{','|implode:$chart['payments']}]
                }]
            });
        });
    </script>
{/if}

{if $user.is_writer || $user.is_editor}
    <script type="text/javascript">
        $(function () {
            $('#admin-chart-income').highcharts({
                chart: {
                    type: 'line'
                },
                title: {
                    text: "Monthly Income Average"
                },
                xAxis,
                yAxis,
                tooltip : {
                    headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                    pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                        '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions,
                series: [{
                    name: "Income",
                    data: [{','|implode:$chart['income']}]
                }]
            });
        });
    </script>
{/if}