<a href="/overview" class="d-none" data-ajax="/overview" id="dashboardRedirectLink"></a>

<div class="clearfix mb20">
    <a href="javascript:void(0);" class="btn btn-default pull-right" id="dashboard-daterangepicker">
        <em class="icon fas fa-calendar mr-2"></em><span>
        {if !empty($range) && in_array($range, array('Today','Yesterday','This Week','This Month','Last Month','This Year'))}
            <span>{$range}</span>
        {elseif !empty($start) && !empty($end)}
            <span>{$range}</span>
        {else}
            <span>This Year</span>
        {/if}
        <em class="icon fas fa-chevron-right ml-2"></em>
    </a>
</div>

{if $user.is_admin}
    
    <div class="row mb20">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-primary">
                <div class="stat-cell">
                    <i class="fa fa-users bg-icon"></i>
                    <span class="text-xlg">{$insights['total_customers']}</span><br>
                    <span class="text-lg">Customers</span><br>
                    <a href="{$base_uri}/customers" data-ajax="/customers">Manage Customers</a>
                </div>
            </div>
        </div>
        
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-warning">
                <div class="stat-cell">
                    <i class="fa fa-users bg-icon"></i>
                    <span class="text-xlg">{$insights['total_employees']}</span><br>
                    <span class="text-lg">Employees</span><br>
                    <a href="{$base_uri}/employees/writers" data-ajax="/employees/writers">Manage Employees</a>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-success">
                <div class="stat-cell">
                    <i class="fa fa-tasks bg-icon"></i>
                    <span class="text-xlg">{$insights['total_orders']}</span><br>
                    <span class="text-lg">Orders</span><br>
                    <a href="{$base_uri}/orders" data-ajax="/orders">Manage Orders</a>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-info">
                <div class="stat-cell">
                    <i class="fab fa-paypal bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights['total_sales'])}</span><br>
                    <span class="text-lg">Total Sales</span><br>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-indigo">
                <div class="stat-cell">
                    <i class="fas fa-money-bill-wave bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights['total_payments'])}</span><br>
                    <span class="text-lg">Writer Payments</span><br>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-red">
                <div class="stat-cell">
                    <i class="fas fa-money-bill-wave bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights['total_payments'])}</span><br>
                    <span class="text-lg">Editor Payments</span><br>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-6">
            <div id="admin-chart-orders" class="admin-chart"></div>
        </div>
        <div class="col-sm-6">
            <div id="admin-chart-customers" class="admin-chart"></div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-6">
            <div id="admin-chart-sales" class="admin-chart"></div>
        </div>
        <div class="col-sm-6">
            <div id="admin-chart-payments" class="admin-chart"></div>
        </div>
    </div>

    <div class="row mb20">
        <div class="col-sm-6">
            <h4 class="mt20">Top Customers</h4>
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <th>Customer</th>
                            <th>Total Orders</th>
                            <th>Total Spent</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $insights['top_customers'] as $customer}
                            <tr>
                                <td><a href="{$base_uri}/customers/edit/{$customer.customer_id}" data-ajax="/customers/edit/{$customer.customer_id}">{$customer.email|strtolower}</a></td>
                                <td>{$customer.c_total_orders}</td>
                                <td>{formatPrice($customer.c_total_spent)}</td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div> 
        <div class="col-sm-6">
            <h4 class="mt20">Top Disciplines</h4>
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover js_dataTable">
                    <thead>
                        <tr>
                            <th>Discipline</th>
                            <th>Total Orders</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $insights['top_disciplines'] as $discipline}
                            <tr>
                                <td>{$discipline.title}</td>
                                <td>{$discipline.discipline_count}</td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
{/if}

{if $user.is_writer || $user.is_editor || $user.is_sub_admin}
    <div class="row mb20">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-primary">
                <div class="stat-cell">
                    <i class="fas fa-money-check-alt bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights.outstanding_payment)}</span><br>
                    <span class="text-lg">Outstanding Payment</span><br>
                    <a href="{$base_uri}/financial-overview/unrequested" data-ajax="/financial-overview/unrequested">Payment Overview</a>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-warning">
                <div class="stat-cell">
                    <i class="fab fa-paypal bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights.last_pay)}</span><br>
                    <span class="text-lg">Last Pay</span><br>
                    <a href="{$base_uri}/financial-overview/history" data-ajax="/financial-overview/history">Payment History</a>
                </div>
            </div>
        </div>
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-success">
                <div class="stat-cell">
                    <i class="fas fa-money-bill-wave bg-icon"></i>
                    <span class="text-xlg">{formatPrice($insights.total_paid)}</span><br>
                    <span class="text-lg">Total Earned</span><br>
                    <a class="text-link" href="{$base_uri}/financial-overview/history" data-ajax="/financial-overview/history">Payment History</a>
                </div>
            </div>
        </div>
    </div>

    <div id="admin-chart-income" class="admin-chart"></div>
{/if}
<!-- Admin Charts -->

<script type="text/javascript">
    {if $main_range == 'Custom'}
        var chartLabels = [{", "|implode:$chart['chartLabels'] nofilter}];
    {else}
        var chartLabels = ["{'", "'|implode:$chart['chartLabels'] nofilter}"];
    {/if}

    var xAxis = {
        categories: chartLabels,
        crosshair: true
    };

    var yAxis = {
        min: 0,
        title: {
            text: "{'Y'|date}"
        }
    };

    var tooltip = {
        headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
        pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
            '<td style="padding:0"><b>{literal}{point.y}{/literal}</b></td></tr>',
        footerFormat: '</table>',
        shared: true,
        useHTML: true
    };

    var plotOptions = {
        column: {
            pointPadding: 0.2,
            borderWidth: 0
        }
    };
</script>

{if $user.is_admin}
    <script type="text/javascript">
        $(document).ready(function() {
            $('#admin-chart-orders').highcharts({
                chart: {
                    type: 'column'
                },
                title: {
                    text: "Monthly Orders Average"
                },
                xAxis,
                yAxis,
                tooltip,
                plotOptions,
                series: [{
                    name: "Orders",
                    data: [{','|implode:$chart['orders_chart']}]
                }]
            });

            $('#admin-chart-customers').highcharts({
                chart: {
                    type: 'column'
                },
                title: {
                    text: "Monthly Customers Average"
                },
                xAxis,
                yAxis,
                tooltip,
                plotOptions,
                series: [{
                    name: "Customers",
                    data: [{','|implode:$chart['customers_chart']}]
                }]
            });

            $('#admin-chart-sales').highcharts({
                chart: {
                    type: 'line'
                },
                title: {
                    text: "Monthly Sales"
                },
                xAxis,
                yAxis,
                tooltip : {
                    headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                    pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                        '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions,
                series: [{
                    name: "Sales",
                    data: [{','|implode:$chart['sales_chart']}]
                }]
            });

            $('#admin-chart-payments').highcharts({
                chart: {
                    type: 'line'
                },
                title: {
                    text: "Monthly Payments"
                },
                xAxis,
                yAxis,
                tooltip : {
                    headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                    pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                        '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions,
                series: [{
                    name: "Payments",
                    data: [{','|implode:$chart.writer_payments_chart}]
                }]
            });
        });
    </script>
{else}
    <script type="text/javascript">
        $(document).ready(function() {
            $('#admin-chart-income').highcharts({
                chart: {
                    type: 'line'
                },
                title: {
                    text: "Monthly Income Average"
                },
                xAxis,
                tooltip : {
                    headerFormat: '<span style="font-size:10px">{literal}{point.key}{/literal}</span><table>',
                    pointFormat: '<tr><td style="color:{literal}{series.color}{/literal};padding:0">{literal}{series.name}{/literal}: </td>' +
                        '<td style="padding:0"><b>${literal}{point.y}{/literal}</b></td></tr>',
                    footerFormat: '</table>',
                    shared: true,
                    useHTML: true
                },
                plotOptions,
                series: [{
                    name: "Income",
                    data: [{','|implode:$chart['income_chart']}]
                }]
            });
        });
    </script>
{/if} 

<script type="text/javascript">
    $(document).ready(function($) {
        {if $user.is_admin}
            var range = { 
                "Today": [moment() , moment()], 
                "Yesterday": [moment().subtract(1, 'days') , moment().subtract(1, 'days')], 
                "This_Week": [moment().subtract(6, 'days') , moment()],
                "This_Month": [moment().startOf('month') , moment().endOf('month')],
                "Last_Month": [moment().subtract(1, 'month').startOf('month') , moment().subtract(1, 'month').endOf('month')],
                "This_Year": [moment().subtract(1, 'year').startOf('year') , moment().subtract(1, 'year').endOf('year')]
            }; 
        {else}
            var range = { 
                "This_Month": [moment().startOf('month') , moment().endOf('month')],
                "Last_Month": [moment().subtract(1, 'month').startOf('month') , moment().subtract(1, 'month').endOf('month')],
                "This_Year": [moment().subtract(1, 'year').startOf('year') , moment().subtract(1, 'year').endOf('year')]
            }; 
        {/if}

        {if !empty($range) && in_array($range, array('Today','Yesterday','This Week','This Month','Last Month','This Year'))}
            {if $range == 'Today'}
                var start = range.Today[0];
                var end = range.Today[1];
            {elseif $range == 'Yesterday'}
                var start = range.Yesterday[0];
                var end = range.Yesterday[1];
            {elseif $range == 'This Week'}
                var start = range.This_Week[0];
                var end = range.This_Week[1];
            {elseif $range == 'This Month'}
                var start = range.This_Month[0];
                var end = range.This_Month[1];
            {elseif $range == 'Last Month'}
                var start = range.Last_Month[0];
                var end = range.Last_Month[1];
            {elseif $range == 'This Year'} 
                var start = range.This_Year[0];
                var end = range.This_Year[1];
            {/if}
        {elseif !empty($range) && !empty($start) && !empty($end)}
            var start = "{$start}";
            var end = "{$end}";
        {else}
            var start = range.This_Year[0];
            var end = range.This_Year[1];
        {/if}

        {if $user.is_admin}
            $('#dashboard-daterangepicker').daterangepicker({
                opens: 'left',
                startDate: start,
                endDate: end,
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'This Week': [moment().subtract(6, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                }
            });
        {else}
            $('#dashboard-daterangepicker').daterangepicker({
                opens: 'left',
                startDate: start,
                endDate: end,
                ranges: {
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                }
            });
        {/if}
    });

    $(document).on('click', '.ranges ul li', function(event) {
        event.preventDefault();
        if ($(this).attr('data-range-key') != 'Custom Range') {
            $(document).off('click', '.ranges ul li');
            $('#dashboardRedirectLink').attr('href', "/overview?range="+$(this).attr('data-range-key'));
            $('#dashboardRedirectLink').attr('data-ajax', "/overview?range="+$(this).attr('data-range-key'));
            $('#dashboardRedirectLink').click();
        }
    });

    $(document).on('click', '.applyBtn', function(event) {
        event.preventDefault();
        $(document).off('click', '.applyBtn');
        $('#dashboardRedirectLink').attr('href', "/overview?range="+$(this).parent('.drp-buttons').find('.drp-selected').html());
        $('#dashboardRedirectLink').attr('data-ajax', "/overview?range="+$(this).parent('.drp-buttons').find('.drp-selected').html());
        $('#dashboardRedirectLink').click();
    });
</script>