<!-- PayPal -->
<div class="tab-pane" id="paypal">
    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updatePayPalSettings">
        <div class="alert alert-info">
            <div class="icon">
                <i class="fas fa-info-circle fa-2x"></i>
            </div>
            <div class="text">
                To start using Paypal, you'll need to create an account at <a target="_blank" href="https://developer.paypal.com/">Paypal</a><br>
                Check the documentation for more help
            </div>
        </div>
        <input type="hidden" name="site_id" value="{$paypalConfiguration.SITE_ID}"/>
        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">PayPal Enabled</div> 
                <div class="form-text">Enable payments via Paypal</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="paypal_enabled"> 
                    <input type="checkbox" name="paypal_enabled" id="paypal_enabled" {if $paypalConfiguration.PAYPAL_ENABLED == '1'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Default</div> 
                <div class="form-text">Make it the default payment method of the site</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="default_method_enabled"> 
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled" {if $paypalConfiguration.PAYMENT_METHOD_DEFAULT == 'paypal'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label">Integration Mode</label>
            <div class="col-sm-9">
                <select class="form-control" name="paypal_integration_mode" data-combo="paypal_integration_mode">
                    <option value="paypal_api_keys" {if $paypalConfiguration.PAYPAL_INTEGRATION_MODE == "paypal_api_keys"}selected=""{/if}>PayPal API Keys</option>
                    <option value="paypal_email" {if $paypalConfiguration.PAYPAL_INTEGRATION_MODE == "paypal_email"}selected=""{/if}>PayPal Email</option>
                </select>
            </div>
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                PayPal Mode
            </label>
            <div class="col-sm-9">
                <div class="form-selectgroup">
                    <label class="form-selectgroup-item" for="paypal_live">
                        <input id="paypal_live" type="radio" name="paypal_mode" value="live" class="form-selectgroup-input" {if $paypalConfiguration.PAYPAL_MODE == 'live'}checked{/if}>
                        <span class="form-selectgroup-label">
                            <i class="icon fas fa-money-check fa-lg"></i>    
                            <span class="text middle">Live</span>
                        </span>
                    </label>
                    <label class="form-selectgroup-item" for="paypal_sandbox">
                        <input id="paypal_sandbox" type="radio" name="paypal_mode" value="sandbox" class="form-selectgroup-input" {if $paypalConfiguration.PAYPAL_MODE == 'sandbox'}checked{/if}>
                        <span class="form-selectgroup-label">
                            <i class="icon fab fa-dev fa-lg"></i>    
                            <span class="text middle">Sandbox</span>
                        </span>
                    </label>
                </div>
            </div>
        </div>
        
        <div id="paypal_integration_mode">
            <div class="switch-combo {if $paypalConfiguration.PAYPAL_INTEGRATION_MODE != "paypal_api_keys"}x-hidden{/if}" data-combo-value="paypal_api_keys">

                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        PayPal Client ID
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="paypal_client_id" id="paypal_client_id" maxlength="255" value="{$paypalConfiguration.PAYPAL_CLIENT_ID}">
                    </div>
                </div>
                
                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        PayPal Secret Key
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="paypal_secret_key" id="paypal_secret_key" maxlength="255" value="{$paypalConfiguration.PAYPAL_SECRET_KEY}">
                    </div>
                </div>
            </div>
            
            <div class="switch-combo {if $paypalConfiguration.PAYPAL_INTEGRATION_MODE != "paypal_email"}x-hidden{/if}" data-combo-value="paypal_email">
                <div class="form-group form-row">
                    <label class="col-sm-3 control-label text-left">
                        PayPal Email
                    </label>
                    <div class="col-sm-9">
                        <input class="form-control" type="text" name="paypal_email" maxlength="255" value="{$paypalConfiguration.PAYPAL_EMAIL}">
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- PayPal -->