<!-- Paystack -->
<div class="tab-pane" id="paystack">
    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updatePaystackSettings">
        <div class="alert alert-info">
            <div class="icon">
                <i class="fas fa-info-circle fa-2x"></i>
            </div>
            <div class="text">
                To start using Paystack, you'll need to create an account at <a target="_blank" href="https://paystack.com">Paystack</a><br>
                Check the documentation for more help
            </div>
        </div>
        <input type="hidden" name="site_id" value="{$paystackConfiguration.SITE_ID}"/>
        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Paystack Enabled</div> 
                <div class="form-text">Enable payments via Paystack</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="paystack_enabled"> 
                    <input type="checkbox" name="paystack_enabled" id="paystack_enabled" {if $paystackConfiguration.PAYSTACK_ENABLED == '1'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Default</div> 
                <div class="form-text">Make it the default payment method of the site</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="default_method_enabled"> 
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled" {if $paystackConfiguration.PAYMENT_METHOD_DEFAULT == 'paystack'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Paystack Mode
            </label>
            <div class="col-sm-9">
                <div class="form-selectgroup">
                    <label class="form-selectgroup-item" for="paystack_live">
                        <input id="paystack_live" type="radio" name="paystack_mode" value="live" class="form-selectgroup-input" {if $paystackConfiguration.PAYSTACK_MODE == 'live'}checked{/if}>
                        <span class="form-selectgroup-label">
                            <i class="icon fas fa-money-check fa-lg"></i>    
                            <span class="text middle">Live</span>
                        </span>
                    </label>
                    <label class="form-selectgroup-item" for="paystack_sandbox">
                        <input id="paystack_sandbox" type="radio" name="paystack_mode" value="sandbox" class="form-selectgroup-input" {if $paystackConfiguration.PAYSTACK_MODE == 'sandbox'}checked{/if}>
                        <span class="form-selectgroup-label">
                            <i class="icon fab fa-dev fa-lg"></i>    
                            <span class="text middle">Sandbox</span>
                        </span>
                    </label>
                </div>
            </div>
        </div>
        
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Paystack Public Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="paystack_public_key" id="paystack_public_key" maxlength="255" value="{$paystackConfiguration.PAYSTACK_PUBLIC_KEY}">
            </div>
        </div>
        
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Paystack Secret Key
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="paystack_secret_key" id="paystack_secret_key" maxlength="255" value="{$paystackConfiguration.PAYSTACK_SECRET_KEY}">
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- Paystack -->