<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\PaymentModule;
use Proxim\Util\ArrayUtils;

class PeachPayments extends PaymentModule
{
    /**
    * PeachPayments configuration
    */
    const PEACHPAYMENTS_ENABLED = 'PEACHPAYMENTS_ENABLED';
    const PEACHPAYMENTS_MODE = 'PEACHPAYMENTS_MODE';
    const PEACHPAYMENTS_ENTITY_ID = 'PEACHPAYMENTS_ENTITY_ID';
    const PEACHPAYMENTS_ACCESS_TOKEN = 'PEACHPAYMENTS_ACCESS_TOKEN';

    public function __construct()
    {
        $this->name = 'peachpayments';
        $this->icon = 'fab fa-credit-card';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';
        $this->displayName = 'Peach Payments';
        $this->description = 'PeachPayment Payment Gateway allows you to accept payment on your site via credit card';

        $this->bootstrap = true;
        parent::__construct();
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin === true;
    }

    public function install()
    { 
        return parent::install() && 
        $this->registerHook('paymentOptions') &&
        $this->registerHook('verifyPayment') &&
        $this->registerHook('displayClientHeader') &&
        $this->registerHook('displayClientFooter');
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . $templateName.'.tpl');
    }

    public function getContent()
    {
        $application = $this->application;

        $peachpaymentsConfiguration = Configuration::getMultiple([
                'PAYMENT_METHOD_DEFAULT',
                self::PEACHPAYMENTS_ENABLED,
                self::PEACHPAYMENTS_MODE,
                self::PEACHPAYMENTS_ENTITY_ID,
                self::PEACHPAYMENTS_ACCESS_TOKEN,
                'SITE_ID'
            ],
            $application->site->id
        );

        $this->smarty->assign([
            'peachpaymentsConfiguration' => $peachpaymentsConfiguration
        ]);

        return $this->getTemplateContent('configure');
    }

    public function updatePeachPaymentsSettings() {
        $app = $this->application;
        $payload = $app->request->post();

        $site_id = (int) $app->request->post('site_id');
        if( ArrayUtils::has($payload, 'default_method_enabled') ) {
            Configuration::updateValue('PAYMENT_METHOD_DEFAULT', $this->name , false, $site_id);
        }

        Configuration::updateValue(self::PEACHPAYMENTS_ENABLED, (ArrayUtils::get($payload, 'peachpayments_enabled') == 'on') ? true : false , false, $site_id);
        Configuration::updateValue(self::PEACHPAYMENTS_MODE, ArrayUtils::get($payload, 'peachpayments_mode'), false, $site_id);
        Configuration::updateValue(self::PEACHPAYMENTS_ENTITY_ID, ArrayUtils::get($payload, 'peachpayments_entity_id'), false, $site_id);
        Configuration::updateValue(self::PEACHPAYMENTS_ACCESS_TOKEN, ArrayUtils::get($payload, 'peachpayments_access_token'), false, $site_id);

        return $app->sendResponse([
            "success" => true,
			"message" => "System settings have been updated"
        ]);
    }
}