{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="{if $sub_view == "listPapers"}wide-lg{else}wide-sm{/if}">
        <div class="nk-block">
            <div class="nk-block-head nk-block-head-sm">
                <div class="nk-block-between">
                    <div class="nk-block-head-content">
                        <h3 class="nk-block-title page-title"> Prewritten Papers
                            {if $sub_view == "viewPaper"} &rsaquo; <strong class="text-primary small">#{$prepaper.id}</strong>{/if}
                            {if $sub_view == "addPaper"} &rsaquo; <strong class="text-primary small">Add New</strong>{/if}
                        </h3>
                    </div>
                    <!-- .nk-block-head-content -->

                    {if $sub_view == "listPapers"}
                        <div class="nk-block-head-content">
                            <div class="toggle-wrap nk-block-tools-toggle">
                                <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                                <div class="toggle-expand-content" data-content="more-options">
                                    <ul class="nk-block-tools g-3">
                                        <li>
                                            <div class="dropdown">
                                                <a href="javascript:void(0);" class="btn btn-trigger btn-icon dropdown-toggle" data-toggle="dropdown">
                                                    {if $is_search}<div class="dot dot-primary"></div>{/if}
                                                    <em class="icon ni ni-filter-alt"></em>
                                                </a>
                                                <div class="filter-wg dropdown-menu dropdown-menu-xl dropdown-menu-right">
                                                    <div class="dropdown-head">
                                                        <span class="sub-title dropdown-title">Filter Papers</span>
                                                    </div>
                                                    <form method="GET" class="dropdown-body dropdown-body-rg" id="filter_form" autocomplete="off">
                                                        <div class="row gx-6 gy-3">
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label class="overline-title overline-title-alt">Title</label>
                                                                    <input class="form-control input-sm" type="text" name="toptitle" placeholder="Title" value="{$toptitle}" />
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label class="overline-title overline-title-alt">Paper ID</label>
                                                                    <input class="form-control input-sm force-integer" type="text" name="paper_id" placeholder="Paper ID" value="{$paper_id}" />
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <label class="overline-title overline-title-alt">Order ID</label>
                                                                    <input class="form-control input-sm force-integer" type="text" name="order_id" placeholder="Order ID" value="{$order_id}" />
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <button name="search" type="submit" class="btn btn-secondary">Filter</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                    <div class="dropdown-foot between">
                                                        <a class="clickable" href="{$base_uri}/prepapers/listPapers">Reset Filter</a>
                                                    </div>
                                                </div><!-- .filter-wg -->
                                            </div><!-- .dropdown -->
                                        </li>

                                        <li class="nk-block-tools-opt">
                                            <a href="{$base_uri}/prepapers/addNew" data-ajax="/prepapers/addNew" class="btn btn-icon btn-primary d-md-none">
                                                <em class="icon ni ni-plus"></em>
                                            </a>
                                            <a href="{$base_uri}/prepapers/addNew" data-ajax="/prepapers/addNew" class="btn btn-primary d-none d-md-inline-flex">
                                                <em class="icon ni ni-plus"></em><span>Add New Paper</span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- .nk-block-head-content -->
                    {/if}

                </div>
            </div>
        </div> 

        <div class="nk-block">

            {if $sub_view == "listPapers"}

                {if count($prepapers)}
                    <table class="nk-tb-list is-separate nk-tb-ulist mb-3">
                        <thead>
                            <tr class="nk-tb-item nk-tb-head">
                                <th class="nk-tb-col">Paper ID</th>
                                <th class="nk-tb-col">Discipline</th>
                                <th class="nk-tb-col">Words</th>
                                <th class="nk-tb-col">Views</th>
                                <th class="nk-tb-col">Purchases</th>
                                <th class="nk-tb-col">Price</th>
                                <th class="nk-tb-col">Created At</th>
                                <th class="nk-tb-col">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $prepapers as $prepaper}
                                <tr class="nk-tb-item">
                                    <td class="nk-tb-col">
                                        <strong><a href="{$base_uri}/prepapers/viewPaper?paperId={$prepaper.id}" data-ajax="/prepapers/viewPaper?paperId={$prepaper.id}">#{$prepaper.id}</a></strong>
                                    </td>
                                    <td class="nk-tb-col">{$prepaper.discipline.title}</td>
                                    <td class="nk-tb-col">{$prepaper.words}</td>
                                    <td class="nk-tb-col">{$prepaper.views}</td>
                                    <td class="nk-tb-col">{$prepaper.downloads}</td>
                                    <td class="nk-tb-col fw-bold text-success">{$prepaper.priceFormatted}</td>
                                    <td class="nk-tb-col">
                                        <span class="js_moment" data-time="{$prepaper.createdAt}">{$prepaper.createdAt}</span>
                                    </td>
                                    <td class="nk-tb-col">
                                        <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-icon btn-danger btn-sm js_deleter" data-handle="prepaper" data-id="{$prepaper.id}">
                                            <i class="icon ni ni-trash-alt"></i>
                                        </button>
                                        <a data-toggle="tooltip" data-placement="top" title="View" href="{$base_uri}/prepapers/viewPaper?paperId={$prepaper.id}" class="btn btn-icon btn-sm btn-primary">
                                            <i class="icon ni ni-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>

                    {$pager nofilter}

                {else}
                    <div class="text-center py-5"> 
                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                        <h6 class="text-dark title mb-3">No prepapers to show</h6>
                    </div>
                {/if}
                
            {elseif $sub_view == "viewPaper"}
                <div class="row">
                    <div class="col-xs-12 col-sm-6">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.id}</span>
                                Paper ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.priceFormatted}</span>
                                Price
                            </li>
                            <li class="list-group-item">
                                <span data-time="{$prepaper.createdAt}" class="badge js_moment">{$prepaper.createdAt}</span>
                                Created At
                            </li>
                        </ul>
                    </div>
                    <div class="col-xs-12 col-sm-6">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.views}</span>
                                Views
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.downloads}</span>
                                Downloads
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.salesFormatted}</span>
                                Sales
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- tabs content -->
                <div class="card card-preview">
                    <div class="card-inner">
                        <!-- tabs nav -->
                        <ul class="nav nav-tabs mt-n3">
                            <li class="nav-item"> 
                                <a href="#info" data-toggle="tab" class="nav-link active">
                                    <i class="icon ni ni-info fa-fw mr5"></i><span class="pr5">Paper Info</span>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="#files" data-toggle="tab" class="nav-link">
                                    <i class="icon ni ni-file fa-fw mr5"></i><span class="pr5">Files</span>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="#previews" data-toggle="tab" class="nav-link">
                                    <i class="icon ni ni-eye fa-fw mr5"></i><span class="pr5">Previews</span>
                                </a>
                            </li>
                            <li class="nav-item"> 
                                <a href="#purchases" data-toggle="tab" class="nav-link">
                                    <i class="icon ni ni-bag fa-fw mr5"></i><span class="pr5">Purchases</span>
                                </a>
                            </li>
                        </ul>
                        <!-- tabs nav -->

                        <!-- tabs content -->
                        <div class="tab-content">
                            <!-- info tab -->
                            <div class="tab-pane active" id="info">
                                <form class="js_ajax-forms form-horizontal" data-url="/prepapers/apiAddNewPaper" autocomplete="off">
                                    <input type="hidden" name="prepaper_id" value="{$prepaper.id}"/>
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Title</label>
                                        <div class="col-sm-9">
                                            <input class="form-control form-control-lg" name="title" value="{$prepaper.title}">
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Permalink (optional)</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <div class="input-group-prepend"> 
                                                    <span class="input-group-text">/paper/</span> 
                                                </div>
                                                <input type="text" class="form-control form-control-lg" name="slug" value="{$prepaper.slug}">
                                            </div>
                                            <span class="help-block">
                                                Valid web address must be a-z0-9_.
                                            </span>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Price (USD)</label>
                                        <div class="col-sm-3">
                                            <div class="input-group">
                                                <div class="input-group-prepend"> 
                                                    <span class="input-group-text">$</span> 
                                                </div>
                                                <input name="price" type="text" class="form-control form-control-lg force-integer" value="{$prepaper.price}">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Question</label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control summernote-minimal" data-height="200" name="question">{$prepaper.question nofilter}</textarea>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Academic Level</label>
                                        <div class="col-sm-9">
                                            <select name="academicLevelId" class="form-select" data-search="on" data-ui="lg">
                                                {foreach $academicLevels as $academicLevel}
                                                    <option value="{$academicLevel.id}" {if $academicLevel.id == $prepaper.academicLevelId}selected=""{/if}>{$academicLevel.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Type of paper</label>
                                        <div class="col-sm-9">
                                            <select name="paperTypeId" class="form-select" data-search="on" data-ui="lg" data-combo="paperType">
                                                {foreach $paperTypes as $paperType}
                                                    <option value="{$paperType.id}" {if $paperType.id == $prepaper.paperTypeId}selected=""{/if}>{$paperType.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div id="paperType">
                                        <div {if $prepaper.paperTypeId == '64'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="64">
                                            <div class="form-group form-row">
                                                <label class="col-sm-3 control-label" for="paperTypeOption">Custom Paper Type:</label>
                                                <div class="col-sm-9">
                                                    <input type="text" class="form-control form-control-lg" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$prepaper.paperTypeOption}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Discipline</label>
                                        <div class="col-sm-9">
                                            <select id="topicCatId" class="form-select" data-search="on" data-ui="lg" name="topicCatId" data-combo="discipline">
                                                {foreach $disciplineGroups as $topicCat}
                                                    <optgroup label="{$topicCat.title}">
                                                        {foreach $topicCat.disciplines as $discipline}
                                                            <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $prepaper.disciplineId == $discipline.discipline_id}selected{/if}>{$discipline.title}</option>
                                                        {/foreach}
                                                    </optgroup>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div id="discipline">
                                        <div {if $prepaper.disciplineId == '52'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="52">
                                            <div class="form-group form-row">
                                                <label class="col-sm-3 control-label" for="topcatOption">Custom Discipline:</label>
                                                <div class="col-sm-9">
                                                    <input type="text" class="form-control form-control-lg" name="topcatOption" id="topcatOption" maxlength="255" value="{$prepaper.disciplineOption}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Paper Format</label>
                                        <div class="col-sm-9">
                                            <select class="form-select" data-search="on" data-ui="lg" name="paperFormat" data-combo="paperFormat">
                                                {foreach $paperFormats as $paperFormat}
                                                    <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == $prepaper.paperFormatId}selected=""{/if}>{$paperFormat.title}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>

                                    <div id="paperFormat">
                                        <div {if $prepaper.paperFormatId == '4'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="4">
                                            <div class="form-group form-row">
                                                <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Format:</label>
                                                <div class="col-sm-9">
                                                    <input class="form-control form-control-lg" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$prepaper.paperFormatOption}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Spacing</label>
                                        <div class="col-sm-9">
                                            <select class="form-select" data-ui="lg" name="spacing" style="width:150px;">
                                                <option {if $prepaper.spacing == 'double'}selected=""{/if} value="double">Double Spaced</option>
                                                <option {if $prepaper.spacing == 'single'}selected=""{/if} value="single">Single Spaced</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Words</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="words" class="form-control form-control-lg js_calculate number-spinner" placeholder="words" value="{$prepaper.words}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Pages</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="pages" class="form-control form-control-lg js_calculate number-spinner" placeholder="pages" value="{$prepaper.pages}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Charts</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="charts" class="form-control form-control-lg js_calculate number-spinner" placeholder="charts" value="{$prepaper.charts}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Slides</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="slides" class="form-control form-control-lg js_calculate number-spinner" placeholder="slides" value="{$prepaper.slides}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label">Sources</label>
                                        <div class="col-sm-4">
                                            <div class="form-control-wrap number-spinner-wrap">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                                    <em class="icon ni ni-minus"></em>
                                                </button>
                                                <input type="text" name="sources" class="form-control form-control-lg js_calculate number-spinner" placeholder="sources" value="{$prepaper.sources}" min="0" max="999">
                                                <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                                    <em class="icon ni ni-plus"></em>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group form-row mt20">
                                        <div class="col-sm-9 offset-sm-3">
                                            <!-- success -->
                                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                            <!-- success -->

                                            <!-- error -->
                                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                            <!-- error -->

                                            <button type="submit" class="btn btn-primary">Save Changes</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- info tab -->

                            <!-- files tab -->
                            <div class="tab-pane" id="files">
                                <form class="js_files-uploader p0 m0" data-handle="prepaper" data-id="{$prepaper.id}" method="POST">
                                    <div class="files-control js_dropzone" data-handle="prepaper" data-id="{$prepaper.id}">
                                        <div class="files-control--files">
                                            {foreach $prepaper.files as $file}
                                                <div class="FormFile" data-handle="prepaper-file" data-id="{$file.id}" data-uploaded="true">
                                                    <div class="FormFile__controls">
                                                        <div class="FormFile__icon">
                                                            <div class="FormFile__icon__badge FormFile__icon__badge--{$file.icon}">{$file.icon}</div>
                                                        </div>
                                                        <button type="button" class="FormFile__info">
                                                            <div class="FormFile__title">
                                                                <a href="{$file.download_link}" class="text-primary">{$file.name}</a>
                                                            </div>
                                                            <span class="FormFile__size">{$file.size_formatted}</span>
                                                            <span class="OrderDetailsFilesCustomersFile__date js_moment" data-time="{$file.date_add}">{$file.date_add}</span>
                                                        </button>
                                                        <button type="button" data-toggle="tooltip" data-title="Delete File" class="FormFile__remove-button"></button>
                                                    </div>
                                                </div>
                                            {/foreach}
                                        </div>
                                        <div class="dropzone-description">
                                            <button class="browse-button btn btn-primary" type="button">Browse </button>
                                            <span class="control-or">or</span>
                                            <span class="control-drop-here">Drop files here</span>
                                        </div>
                                        <div class="dropzone-static">
                                            <div class="dropzone-border">Drop files here</div>
                                        </div>
                                        <input multiple="" type="file" style="display: none;" data-handle="prepaper" data-id="{$prepaper.id}">
                                    </div>
                                </form>
                            </div>
                            <!-- files tab -->

                            <!-- previews tab -->
                            <div class="tab-pane" id="previews">
                                <div class="x-form publisher" data-handle="publisher" data-id="{$prepaper.id}">
                                    <!-- preview attachments -->
                                    <div class="publisher-attachments attachments clearfix">
                                        <ul>
                                            <li>
                                                <div class="add-preview-image" data-toggle="tooltip" data-placement="top" title="Add Previews">
                                                    <i class="icon ni ni-camera fa-fw js_x-uploader" accept="image/x-png,image/gif,image/jpeg" data-handle="prepaper-preview" data-id="{$prepaper.id}" data-multiple="true"></i>
                                                </div>
                                            </li>
                                            {foreach $prepaper.previews as $preview}
                                                <li class="item deletable" data-handle="prepaper-preview" data-id="{$preview.id}">
                                                    <div class="item-image" style="background-image:url('{$preview.image_source}');"></div>
                                                    <button type="button" class="close js_publisher-attachment-remover" title="Remove">
                                                        <span>×</span>
                                                    </button>
                                                </li>
                                            {/foreach}
                                        </ul>
                                    </div>
                                    <!-- preview attachments -->
                                </div>
                            </div>
                            <!-- previews tab -->

                            <!-- purchases tab -->
                            <div class="tab-pane" id="purchases">
                                {if count($prepaper.payments)} 
                                    <div class="border round">
                                        <table class="table table-orders">
                                            <thead class="tb-odr-head">
                                                <tr class="tb-odr-item">
                                                    <th class="tb-odr-info">Customer ID</th>
                                                    <th class="tb-odr-info">Payment method</th>
                                                    <th class="tb-odr-info">Amount</th>
                                                    <th class="tb-odr-info">Purchased At</th>
                                                </tr>
                                            </thead>
                                            <tbody class="tb-odr-body">
                                                {foreach $prepaper.payments as $purchase}
                                                    <tr class="tb-odr-item">
                                                        <td class="tb-odr-info">
                                                            <strong>
                                                                <a href="{$base_uri}/customers/edit/{$purchase.customer_id}">#{$purchase.customer_id}</a>
                                                            </strong>
                                                        </td>
                                                        <td class="tb-odr-info">
                                                            {$purchase.payment_method|ucfirst}
                                                        </td>
                                                        <td class="tb-odr-info">
                                                            {$purchase.amount_formatted}
                                                        </td>
                                                        <td class="tb-odr-info">
                                                            <span class="js_moment" data-time="{$purchase.paid_at}">{$purchase.paid_at}</span>
                                                        </td>
                                                    </tr>
                                                {/foreach}
                                            </tbody>
                                        </table>
                                    </div>
                                {else}
                                    <div class="text-center py-5"> 
                                        <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                                        <h6 class="text-dark title mb-3">No purchases to show</h6>
                                    </div>
                                {/if}
                            </div>
                            <!-- purchases tab -->
                        </div>
                        <!-- tabs content -->
                    </div>
                </div>
            {elseif $sub_view == "addPaper"}
                <form class="card card-preview js_ajax-forms" data-url="/prepapers/apiAddNewPaper" autocomplete="off">
                    <div class="card-inner">
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Title</label>
                            <div class="col-sm-9">
                                <input class="form-control form-control-lg" name="title">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Permalink (optional)</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text">/papers/</span> 
                                    </div>
                                    <input type="text" class="form-control form-control-lg" name="slug">
                                </div>
                                <span class="help-block">Valid web address must be a-z0-9_. If left blank it will be auto generated</span>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Price (USD)</label>
                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text">$</span> 
                                    </div>
                                    <input name="price" type="text" class="form-control form-control-lg force-integer">
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Question</label>
                            <div class="col-sm-9">
                                <textarea class="form-control summernote-minimal" data-height="200" name="question"></textarea>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Academic Level</label>
                            <div class="col-sm-9">
                                <select name="academicLevelId" class="form-select" data-search="on" data-ui="lg">
                                    {foreach $academicLevels as $academicLevel}
                                        <option value="{$academicLevel.id}">{$academicLevel.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Type of paper</label>
                            <div class="col-sm-9">
                                <select name="paperTypeId" class="form-select" data-search="on" data-ui="lg" data-combo="paperType">
                                    {foreach $paperTypes as $paperType}
                                        <option value="{$paperType.id}">{$paperType.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperType">
                            <div class="switch-combo x-hidden" data-combo-value="64">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Type:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control form-control-lg" name="paperTypeOption" id="paperTypeOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Discipline</label>
                            <div class="col-sm-9">
                                <select id="topicCatId" class="form-select" data-search="on" data-ui="lg" name="topicCatId" data-combo="discipline">
                                    {foreach $disciplineGroups as $topicCat}
                                        <optgroup label="{$topicCat.title}">
                                            {foreach $topicCat.disciplines as $discipline}
                                                <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}">{$discipline.title}</option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="discipline">
                            <div class="switch-combo x-hidden" data-combo-value="52">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Discipline:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control form-control-lg" name="topcatOption" id="topcatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Paper Format</label>
                            <div class="col-sm-9">
                                <select class="form-select" data-search="on" data-ui="lg" name="paperFormat" data-combo="paperFormat">
                                    {foreach $paperFormats as $paperFormat}
                                        <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == "1"}selected=""{/if}>{$paperFormat.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperFormat">
                            <div class="switch-combo x-hidden" data-combo-value="4">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Format:</label>
                                    <div class="col-sm-9">
                                        <input class="form-control form-control-lg" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Spacing</label>
                            <div class="col-sm-9">
                                <select class="form-select" data-ui="lg" name="spacing" style="width:150px;">
                                    <option value="double">Double Spaced</option>
                                    <option value="single">Single Spaced</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Words</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="words" class="form-control form-control-lg js_calculate number-spinner" placeholder="words" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Pages</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="pages" class="form-control form-control-lg js_calculate number-spinner" placeholder="pages" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Charts</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="charts" class="form-control form-control-lg js_calculate number-spinner" placeholder="charts" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Slides</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="slides" class="form-control form-control-lg js_calculate number-spinner" placeholder="slides" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Sources</label>
                            <div class="col-sm-4">
                                <div class="form-control-wrap number-spinner-wrap">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-minus js_calculate" data-number="minus">
                                        <em class="icon ni ni-minus"></em>
                                    </button>
                                    <input type="text" name="sources" class="form-control form-control-lg js_calculate number-spinner" placeholder="sources" value="0" min="0" max="999">
                                    <button type="button" class="btn btn-lg btn-icon btn-outline-light number-spinner-btn number-plus js_calculate" data-number="plus">
                                        <em class="icon ni ni-plus"></em>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group form-row">
                            <div class="col-sm-9">
                                <!-- success -->
                                <div class="alert alert-success mt10 mb0 x-hidden" role="alert"></div>
                                <!-- success -->

                                <!-- error -->
                                <div class="alert alert-danger mt10 mb0 x-hidden" role="alert"></div>
                                <!-- error -->
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Add New Sample</button>
                    </div>
                </form>
            {/if}

        </div>
            
    </div>
{/block}