{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            {if $sub_view == "listPapers"}
                <div class="pull-right flip">
                    <a class="btn btn-primary" href="{$base_uri}/prepapers/addNew" data-ajax="/prepapers/addNew">
                        <i class="fa fa-plus"></i> Add New Paper
                    </a>
                </div>
            {/if}

            <i class="fa fa-book mr10"></i> 
            <strong>Prewritten Papers</strong>
            {if $sub_view == "addPaper"}
                &rsaquo; <strong>Add New</strong>
            {elseif $sub_view == "viewPaper"}
                &rsaquo; <strong>{$prepaper.id}</strong>
            {/if} 
        </div>

        {if $sub_view == "listPapers"}

            <div class="card-body">
                <form method="GET" id="filter_form" autocomplete="off">
                    <div class="row mb10">
                        <div class="col-md-4">
                            <label for="toptitle">Topic Title:</label>
                            <input class="form-control input-sm" type="text" name="toptitle" placeholder="Topic Title" value="{$toptitle}" />
                        </div>
                        <div class="col-md-2">
                            <label for="paper_id">Paper ID:</label>
                            <input class="form-control input-sm force-integer" type="text" name="paper_id" placeholder="Paper Id" value="{$paper_id}" />
                        </div>
                        <div class="col-md-2">
                            <label for="order_id">Order ID:</label>
                            <input class="form-control input-sm force-integer" type="text" name="order_id" placeholder="Order Id" value="{$order_id}" />
                        </div>
                        <div class="col-md-2">
                            <button name="search" class="btn btn-primary mt20"><i class="fa fa-search mr5"></i>Search</button>
                        </div>
                    </div>
                </form>

                {if count($prepapers)}
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <th>Paper ID</th>
                                    <th>Discipline</th>
                                    <th>Words</th>
                                    <th>Views</th>
                                    <th>Purchases</th>
                                    <th>Price</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $prepapers as $prepaper}
                                    <tr>
                                        <td>
                                            <strong><a href="{$base_uri}/prepapers/viewPaper?paperId={$prepaper.id}" data-ajax="/prepapers/viewPaper?paperId={$prepaper.id}">#{$prepaper.id}</a></strong>
                                        </td>
                                        <td>{$prepaper.discipline.title}</td>
                                        <td>{$prepaper.words}</td>
                                        <td>{$prepaper.views}</td>
                                        <td>{$prepaper.downloads}</td>
                                        <td>{$prepaper.priceFormatted}</td>
                                        <td>
                                            <span class="js_moment" data-time="{$prepaper.createdAt}">{$prepaper.createdAt}</span>
                                        </td>
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="prepaper" data-id="{$prepaper.id}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <a data-toggle="tooltip" data-placement="top" title="View" href="{$base_uri}/prepapers/viewPaper?paperId={$prepaper.id}" class="btn btn-xs btn-primary">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> 
                        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                        <p class="mb10"><strong>No prepapers to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "viewPaper"}

            <div class="card-body">
                <div class="row">
                    <div class="col-xs-12 col-sm-5 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.id}</span>
                                Paper ID
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.priceFormatted}</span>
                                Price
                            </li>
                            <li class="list-group-item">
                                <span data-time="{$prepaper.createdAt}" class="badge js_moment">{$prepaper.createdAt}</span>
                                Created At
                            </li>
                        </ul>
                    </div>
                    <div class="col-xs-12 col-sm-5 mb10">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.views}</span>
                                Views
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.downloads}</span>
                                Downloads
                            </li>
                            <li class="list-group-item">
                                <span class="badge">{$prepaper.salesFormatted}</span>
                                Sales
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- tabs nav -->
                <ul class="nav nav-tabs mb20">
                    <li class="nav-item"> 
                        <a href="#info" data-toggle="tab" class="nav-link active">
                            <i class="fa fa-info fa-fw mr5"></i><strong class="pr5">Paper Info</strong>
                        </a>
                    </li>
                    <li class="nav-item"> 
                        <a href="#files" data-toggle="tab" class="nav-link">
                            <i class="fa fa-file fa-fw mr5"></i><strong class="pr5">Files</strong>
                        </a>
                    </li>
                    <li class="nav-item"> 
                        <a href="#previews" data-toggle="tab" class="nav-link">
                            <i class="fa fa-eye fa-fw mr5"></i><strong class="pr5">Previews</strong>
                        </a>
                    </li>
                    <li class="nav-item"> 
                        <a href="#purchases" data-toggle="tab" class="nav-link">
                            <i class="fa fa-shopping-basket fa-fw mr5"></i><strong class="pr5">Purchases</strong>
                        </a>
                    </li>
                </ul>
                <!-- tabs nav -->
                
                <!-- tabs content -->
                <div class="tab-content">

                    <!-- info tab -->
                    <div class="tab-pane active" id="info">
                        <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/prepapers/apiAddNewPaper" autocomplete="off">
                            <input type="hidden" name="prepaper_id" value="{$prepaper.id}"/>
                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Title</label>
                                <div class="col-sm-9">
                                    <input class="form-control" name="title" value="{$prepaper.title}">
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Permalink (optional)</label>
                                <div class="col-sm-9">
                                    <div class="input-group">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text">/paper/</span> 
                                        </div>
                                        <input type="text" class="form-control" name="slug" value="{$prepaper.slug}">
                                    </div>
                                    <span class="help-block">
                                        Valid web address must be a-z0-9_.
                                    </span>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Price (USD)</label>
                                <div class="col-sm-3">
                                    <div class="input-group">
                                        <div class="input-group-prepend"> 
                                            <span class="input-group-text">$</span> 
                                        </div>
                                        <input name="price" type="text" class="form-control force-integer" value="{$prepaper.price}">
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Question</label>
                                <div class="col-sm-9">
                                    <textarea class="form-control js_summernote" data-height="200" name="question">{$prepaper.question nofilter}</textarea>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Academic Level</label>
                                <div class="col-sm-9">
                                    <select name="academicLevelId" class="form-control select_search">
                                        {foreach $academicLevels as $academicLevel}
                                            <option value="{$academicLevel.id}" {if $academicLevel.id == $prepaper.academicLevelId}selected=""{/if}>{$academicLevel.title}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Type of paper</label>
                                <div class="col-sm-9">
                                    <select name="paperTypeId" class="form-control select_search" data-combo="paperType">
                                        {foreach $paperTypes as $paperType}
                                            <option value="{$paperType.id}" {if $paperType.id == $prepaper.paperTypeId}selected=""{/if}>{$paperType.title}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div id="paperType">
                                <div {if $prepaper.paperTypeId == '64'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="64">
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label" for="paperTypeOption">Custom Paper Type:</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="paperTypeOption" id="paperTypeOption" maxlength="255" value="{$prepaper.paperTypeOption}">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Discipline</label>
                                <div class="col-sm-9">
                                    <select id="topicCatId" class="form-control select_search" name="topicCatId" data-combo="discipline">
                                        {foreach $disciplineGroups as $topicCat}
                                            <optgroup label="{$topicCat.title}">
                                                {foreach $topicCat.disciplines as $discipline}
                                                    <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}" {if $prepaper.disciplineId == $discipline.discipline_id}selected{/if}>{$discipline.title}</option>
                                                {/foreach}
                                            </optgroup>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div id="discipline">
                                <div {if $prepaper.disciplineId == '52'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="52">
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label" for="topcatOption">Custom Discipline:</label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control" name="topcatOption" id="topcatOption" maxlength="255" value="{$prepaper.disciplineOption}">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Paper Format</label>
                                <div class="col-sm-9">
                                    <select class="form-control select_search" name="paperFormat" data-combo="paperFormat">
                                        {foreach $paperFormats as $paperFormat}
                                            <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == $prepaper.paperFormatId}selected=""{/if}>{$paperFormat.title}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>

                            <div id="paperFormat">
                                <div {if $prepaper.paperFormatId == '4'}class="switch-combo"{else}class="switch-combo x-hidden"{/if} data-combo-value="4">
                                    <div class="form-group form-row">
                                        <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Format:</label>
                                        <div class="col-sm-9">
                                            <input class="form-control" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255" value="{$prepaper.paperFormatOption}">
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Spacing</label>
                                <div class="col-sm-9">
                                    <select class="form-control" name="spacing" style="width:150px;">
                                        <option {if $prepaper.spacing == 'double'}selected=""{/if} value="double">Double Spaced</option>
                                        <option {if $prepaper.spacing == 'single'}selected=""{/if} value="single">Single Spaced</option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Words</label>
                                <div class="col-sm-4">
                                    <div class="control-stepper">
                                        <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                        <input name="words" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$prepaper.words}">
                                        <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Pages</label>
                                <div class="col-sm-4">
                                    <div class="control-stepper">
                                        <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                        <input name="pages" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$prepaper.pages}">
                                        <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Charts</label>
                                <div class="col-sm-4">
                                    <div class="control-stepper">
                                        <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                        <input name="charts" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$prepaper.charts}">
                                        <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Slides</label>
                                <div class="col-sm-4">
                                    <div class="control-stepper">
                                        <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                        <input name="slides" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$prepaper.slides}">
                                        <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group form-row">
                                <label class="col-sm-3 control-label">Sources</label>
                                <div class="col-sm-4">
                                    <div class="control-stepper">
                                        <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                        <input name="sources" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="{$prepaper.sources}">
                                        <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group form-row mt20">
                                <div class="col-sm-9 offset-sm-3">
                                    <!-- success -->
                                    <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                                    <!-- success -->

                                    <!-- error -->
                                    <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                                    <!-- error -->

                                    <button type="submit" class="btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- info tab -->

                    <!-- files tab -->
                    <div class="tab-pane" id="files">
                        <div class="row">
                            <div class="col-md-8">
                                <form class="js_files-uploader p0 m0" data-handle="prepaper" data-id="{$prepaper.id}" method="POST">
                                    <div class="files-control js_dropzone" data-handle="prepaper" data-id="{$prepaper.id}">
                                        <div class="files-control--files">
                                            {foreach $prepaper.files as $file}
                                                <div class="FormFile" data-handle="prepaper-file" data-id="{$file.id}" data-uploaded="true">
                                                    <div class="FormFile__controls">
                                                        <div class="FormFile__icon">
                                                            <div class="FormFile__icon__badge FormFile__icon__badge--{$file.icon}">{$file.icon}</div>
                                                        </div>
                                                        <button type="button" class="FormFile__info">
                                                            <div class="FormFile__title">
                                                                <a href="{$file.download_link}" class="text-primary">{$file.name}</a>
                                                            </div>
                                                            <span class="FormFile__size">{$file.size_formatted}</span>
                                                            <span class="OrderDetailsFilesCustomersFile__date js_moment" data-time="{$file.date_add}">{$file.date_add}</span>
                                                        </button>
                                                        <button type="button" data-toggle="tooltip" data-title="Delete File" class="FormFile__remove-button"></button>
                                                    </div>
                                                </div>
                                            {/foreach}
                                        </div>
                                        <div class="dropzone-description">
                                            <button class="browse-button btn btn-primary" type="button">Browse </button>
                                            <span class="control-or">or</span>
                                            <span class="control-drop-here">Drop files here</span>
                                        </div>
                                        <div class="dropzone-static">
                                            <div class="dropzone-border">Drop files here</div>
                                        </div>
                                        <input multiple="" type="file" style="display: none;" data-handle="prepaper" data-id="{$prepaper.id}">
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                    <!-- files tab -->

                    <!-- previews tab -->
                    <div class="tab-pane" id="previews">
                        <div class="row">
                            <div class="x-form publisher" data-handle="publisher" data-id="{$prepaper.id}">
                                <!-- preview attachments -->
                                <div class="publisher-attachments attachments clearfix">
                                    <ul>
                                        <li>
                                            <div class="add-preview-image" data-toggle="tooltip" data-placement="top" title="Add Previews">
                                                <i class="fa fa-camera fa-fw js_x-uploader" accept="image/x-png,image/gif,image/jpeg" data-handle="prepaper-preview" data-id="{$prepaper.id}" data-multiple="true"></i>
                                            </div>
                                        </li>
                                        {foreach $prepaper.previews as $preview}
                                            <li class="item deletable" data-handle="prepaper-preview" data-id="{$preview.id}">
                                                <div class="item-image" style="background-image:url('{$preview.image_source}');"></div>
                                                <button type="button" class="close js_publisher-attachment-remover" title="Remove">
                                                    <span>×</span>
                                                </button>
                                            </li>
                                        {/foreach}
                                    </ul>
                                </div>
                                <!-- preview attachments -->
                            </div>
                        </div>
                    </div>
                    <!-- previews tab -->

                    <!-- purchases tab -->
                    <div class="tab-pane" id="purchases">
                        {if count($prepaper.payments)}
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered table-hover js_dataTable">
                                    <thead>
                                        <tr>
                                            <th>Customer ID</th>
                                            <th>Payment method</th>
                                            <th>Amount</th>
                                            <th>Purchased At</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {foreach $prepaper.payments as $purchase}
                                            <tr>
                                                <td>
                                                    <strong>
                                                        <a href="{$base_uri}/customers/edit/{$purchase.customer_id}">#{$purchase.customer_id}</a>
                                                    </strong>
                                                </td>
                                                <td>
                                                    {$purchase.payment_method}
                                                </td>
                                                <td>
                                                    {$purchase.amount_formatted}
                                                </td>
                                                <td>
                                                    <span class="js_moment" data-time="{$purchase.paid_at}">{$purchase.paid_at}</span>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
                            </div>
                        {else}
                            <div class="text-center x-muted"> 
                                <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
                                <p class="mb10"><strong>No purchases to show</strong></p>
                            </div>
                        {/if}
                    </div>
                    <!-- purchases tab -->

                </div>
            </div>

        {elseif $sub_view == "addPaper"}

            <form class="js_ajax-forms" data-url="/prepapers/apiAddNewPaper" autocomplete="off">
                <div class="card-body">
                    <div class="col-md-9 form-horizontal">
                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Title</label>
                            <div class="col-sm-9">
                                <input class="form-control" name="title">
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Permalink (optional)</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text">/papers/</span> 
                                    </div>
                                    <input type="text" class="form-control" name="slug">
                                </div>
                                <span class="help-block">Valid web address must be a-z0-9_. If left blank it will be auto generated</span>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Price (USD)</label>
                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-prepend"> 
                                        <span class="input-group-text">$</span> 
                                    </div>
                                    <input name="price" type="text" class="form-control force-integer">
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Question</label>
                            <div class="col-sm-9">
                                <textarea class="form-control js_summernote" data-height="200" name="question"></textarea>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Academic Level</label>
                            <div class="col-sm-9">
                                <select name="academicLevelId" class="form-control select_search">
                                    {foreach $academicLevels as $academicLevel}
                                        <option value="{$academicLevel.id}">{$academicLevel.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Type of paper</label>
                            <div class="col-sm-9">
                                <select name="paperTypeId" class="form-control select_search" data-combo="paperType">
                                    {foreach $paperTypes as $paperType}
                                        <option value="{$paperType.id}">{$paperType.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperType">
                            <div class="switch-combo x-hidden" data-combo-value="64">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Type:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="paperTypeOption" id="paperTypeOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Discipline</label>
                            <div class="col-sm-9">
                                <select id="topicCatId" class="form-control select_search" name="topicCatId" data-combo="discipline">
                                    {foreach $disciplineGroups as $topicCat}
                                        <optgroup label="{$topicCat.title}">
                                            {foreach $topicCat.disciplines as $discipline}
                                                <option data-complex="{$discipline.is_complex_assignment}" value="{$discipline.discipline_id}">{$discipline.title}</option>
                                            {/foreach}
                                        </optgroup>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="discipline">
                            <div class="switch-combo x-hidden" data-combo-value="52">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Discipline:</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" name="topcatOption" id="topcatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Paper Format</label>
                            <div class="col-sm-9">
                                <select class="form-control select_search" name="paperFormat" data-combo="paperFormat">
                                    {foreach $paperFormats as $paperFormat}
                                        <option value="{$paperFormat.paper_format_id}" {if $paperFormat.paper_format_id == "1"}selected=""{/if}>{$paperFormat.title}</option>
                                    {/foreach}
                                </select>
                            </div>
                        </div>

                        <div id="paperFormat">
                            <div class="switch-combo x-hidden" data-combo-value="4">
                                <div class="form-group form-row">
                                    <label class="col-sm-3 control-label" for="paperFormatOption">Custom Paper Format:</label>
                                    <div class="col-sm-9">
                                        <input class="form-control" type="text" name="paperFormatOption" id="paperFormatOption" maxlength="255">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Spacing</label>
                            <div class="col-sm-9">
                                <select class="form-control" name="spacing" style="width:150px;">
                                    <option value="double">Double Spaced</option>
                                    <option value="single">Single Spaced</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Words</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="words" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="275">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Pages</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="pages" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="1">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Charts</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="charts" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Slides</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="slides" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>

                        <div class="form-group form-row">
                            <label class="col-sm-3 control-label">Sources</label>
                            <div class="col-sm-4">
                                <div class="control-stepper">
                                    <button type="button" class="btn control-stepper__minus-button incr-btn" data-action="decrease">-</button>
                                    <input name="sources" type="text" class="form-control control-stepper__input force-integer quantity" data-minvalue="0" value="0">
                                    <button type="button" class="btn control-stepper__plus-button incr-btn" data-action="increase">+</button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group form-row">
                            <div class="col-sm-9">
                                <!-- success -->
                                <div class="alert alert-success mt10 mb0 x-hidden" role="alert"></div>
                                <!-- success -->

                                <!-- error -->
                                <div class="alert alert-danger mt10 mb0 x-hidden" role="alert"></div>
                                <!-- error -->
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Add New Paper</button>
                </div>
            </form>

        {/if}
    </div>
    
{/block}