<?php
use Proxim\Application;
use Proxim\Module\Module;
use Proxim\Preference\Deadline;
use Proxim\Preference\Deliverable;
use Proxim\Preference\Descriptor;
use Proxim\Preference\Discipline;
use Proxim\Preference\ItemPricing;
use Proxim\Site\Site;
use Proxim\Util\DateUtils;

class Programming extends Module
{
    public function __construct()
    {
        $this->name = 'programming';
        $this->icon = 'fas fa-code';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Programming';
        $this->description = 'Offer programming services to your customers';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin ? true : false;
    }

    public function install()
    {
        $this->createTables();

        if (!parent::install()) {
            return false;
        }
    }

    public function createTables() {
        try {
            Db::getInstance()->Execute("
                CREATE TABLE IF NOT EXISTS `prox_descriptor` (
                    `descriptor_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `discipline_id` BIGINT(20) UNSIGNED NOT NULL,
                    `task_size_id` BIGINT(20) UNSIGNED NOT NULL,
                    `example` TEXT NOT NULL,
                    `is_calculations` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
                    `is_programming` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
                    `date_upd` DATETIME DEFAULT NULL,
                    `date_add` DATETIME DEFAULT NULL,
                PRIMARY KEY(`descriptor_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
            ");
        } catch (\Exception $e) {

        }

        try {
            Db::getInstance()->Execute("
                CREATE TABLE IF NOT EXISTS `prox_descriptor_deliverable` (
                    `descriptor_deliverable_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `descriptor_id` BIGINT(20) UNSIGNED NOT NULL,
                    `deliverable_id` BIGINT(20) UNSIGNED NOT NULL,
                    `date_upd` DATETIME DEFAULT NULL,
                    `date_add` DATETIME DEFAULT NULL,
                PRIMARY KEY(`descriptor_deliverable_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
            ");
        } catch (\Exception $e) {

        }

        try {
            Db::getInstance()->Execute("
                CREATE TABLE IF NOT EXISTS `prox_item_pricing` (
                    `item_pricing_id` BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `discipline_id` BIGINT(20) UNSIGNED NOT NULL,
                    `task_size_id` BIGINT(20) UNSIGNED NOT NULL,
                    `price` FLOAT(14,2) NOT NULL DEFAULT 0.00,
                    `is_calculations` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
                    `is_programming` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0',
                    `date_upd` DATETIME DEFAULT NULL,
                    `date_add` DATETIME DEFAULT NULL,
                PRIMARY KEY(`item_pricing_id`)) ENGINE = InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;
            ");
        } catch (\Exception $e) {

        }

        try {
            Db::getInstance()->Execute("
                ALTER TABLE `prox_descriptor` ADD (
                    `date_upd` DATETIME DEFAULT NULL
                );
            ");
        } catch (\Exception $e) {

        }

        try {
            Db::getInstance()->Execute("
                ALTER TABLE `prox_descriptor_deliverable` ADD (
                    `date_upd` DATETIME DEFAULT NULL
                );
            ");
        } catch (\Exception $e) {

        }

        try {
            Db::getInstance()->Execute("
                ALTER TABLE `prox_item_pricing` ADD (
                    `date_upd` DATETIME DEFAULT NULL
                );
            ");
        } catch (\Exception $e) {

        }

        $deliverables = array(
            [
                'name' => '3D CAD model', 
                'slug' => '3d-cad-model'
            ],
                    
            [
                'name' => 'Advanced report (research proposal, dissertation/thesis chapter, etc.)', 
                'slug' => 'advanced-report'
            ],
                    
            [
                'name' => 'Brief report', 
                'slug' => 'brief-report'
            ],
                    
            [
                'name' => 'Calculations', 
                'slug' => 'calculations'
            ],
                    
            [
                'name' => 'Charts and diagrams', 
                'slug' => 'charts-and-diagrams'
            ],
                    
            [
                'name' => 'Complex models', 
                'slug' => 'complex-models'
            ],
                    
            [
                'name' => 'Computations', 
                'slug' => 'computations'
            ],
                    
            [
                'name' => 'Data schema with explanations', 
                'slug' => 'data-schema-with-explanations'
            ],
                    
            [
                'name' => 'Database schema', 
                'slug' => 'database-schema'
            ],
                    
            [
                'name' => 'Detailed explanations', 
                'slug' => 'detailed-explanations'
            ],
                    
            [
                'name' => 'Detailed report', 
                'slug' => 'detailed-report'
            ],
                    
            [
                'name' => 'Documentation', 
                'slug' => 'documentation'
            ],
                    
            [
                'name' => 'Drawings, tables and map filling', 
                'slug' => 'drawings-tables-and-map-filling'
            ],
                    
            [
                'name' => 'Experiment observations', 
                'slug' => 'experiment-observations'
            ],
                    
            [
                'name' => 'Simple 3D CAD model', 
                'slug' => 'simple-3d-cad-model'
            ],
                    
            [
                'name' => 'Map production', 
                'slug' => 'map-production'
            ],
                    
            [
                'name' => 'Models, charts and calculations', 
                'slug' => 'models-charts-and-calculations'
            ],
                    
            [
                'name' => 'Models, drawings and charts', 
                'slug' => 'models-drawings-and-charts'
            ],
                    
            [
                'name' => 'Observations and forecasts', 
                'slug' => 'observations-and-forecasts'
            ],
                    
            [
                'name' => 'Presentation', 
                'slug' => 'presentation'
            ],
                    
            [
                'name' => 'Problem analysis', 
                'slug' => 'problem-analysis'
            ],
                    
            [
                'name' => 'Screenshots of outputs', 
                'slug' => 'screenshots-of-outputs'
            ],
                    
            [
                'name' => 'Scripts and source code', 
                'slug' => 'scripts-and-source-code'
            ],
                    
            [
                'name' => 'Short answers to questions', 
                'slug' => 'short-answers-to-questions'
            ],
                    
            [
                'name' => 'Simple calculations', 
                'slug' => 'simple-calculations'
            ],
                    
            [
                'name' => 'Simple charts and calculations', 
                'slug' => 'simple-charts-and-calculations'
            ],
                    
            [
                'name' => 'Simple charts and diagrams', 
                'slug' => 'simple-charts-and-diagrams'
            ],
                    
            [
                'name' => 'Simple computations', 
                'slug' => 'simple-computations'
            ],
                    
            [
                'name' => 'Simple database schema', 
                'slug' => 'simple-database-schema'
            ],
                    
            [
                'name' => 'Simple drawings, tables and map filling', 
                'slug' => 'simple-drawings-tables-map'
            ],
                    
            [
                'name' => 'Simple operations and computations', 
                'slug' => 'simple-operations-and-computations'
            ],
                    
            [
                'name' => 'Simple queries and charts', 
                'slug' => 'simple-queries-and-charts'
            ],
                    
            [
                'name' => 'Simple statistical models', 
                'slug' => 'simple-statistical-models'
            ],
                    
            [
                'name' => 'Simple tables and charts', 
                'slug' => 'simple-tables-and-charts'
            ],
                    
            [
                'name' => 'Source code', 
                'slug' => 'source-code'
            ],
                    
            [
                'name' => 'Statistical models', 
                'slug' => 'statistical-models'
            ],
                    
            [
                'name' => 'Statistical scripts', 
                'slug' => 'statistical-scripts'
            ],
                    
            [
                'name' => 'Structure and flowcharts', 
                'slug' => 'structure-and-flowcharts'
            ],
                    
            [
                'name' => 'Tables and charts', 
                'slug' => 'tables-and-charts'
            ]
        );

        foreach($deliverables as $del ) {
            $deliverableId = (int) Db::getInstance()->getValue('SELECT deliverable_id FROM ' . Db::prefix('deliverable') . ' WHERE slug =  \'' . pSQL($del['slug']) . '\'');
            if($deliverableId) {
                $deliverable = new Deliverable( $deliverableId );
                $deliverable->name = $del['name'];
                $deliverable->slug = $del['slug'];
                $deliverable->update();
            } else {
                $deliverable = new Deliverable();
                $deliverable->name = $del['name'];
                $deliverable->slug = $del['slug'];
                $deliverable->add();
            }
            
        }

        $disciplines = array(
            [
                'title' => 'Web programming',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 15 practice problems, small lab report, or responsive webpage',
                        'slugs' => [
                            'brief-report',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report, responsive website of 2-5 pages, or a web-based product with 1-2 scenarios',
                        'slugs' => [
                            'detailed-report',
                            'documentation',
                            'presentation',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => 'Mobile applications development',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, or app with 1-3 simple scenarios',
                        'slugs' => [
                            'brief-report',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report or application with 4-6 scenarios',
                        'slugs' => [
                            'detailed-report',
                            'documentation',
                            'presentation',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => 'Desktop applications development',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, or app with 1-3 simple scenarios',
                        'slugs' => [
                            'brief-report',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report or application with 4-6 scenarios',
                        'slugs' => [
                            'detailed-report',
                            'documentation',
                            'presentation',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => 'Database design and optimization',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'short-answers-to-questions',
                            'simple-database-schema',
                            'simple-queries-and-charts'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'short-answers-to-questions',
                            'simple-database-schema',
                            'simple-queries-and-charts'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, or simple DB design project',
                        'slugs' => [
                            'brief-report',
                            'simple-database-schema',
                            'simple-queries-and-charts',
                            'structure-and-flowcharts'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report, DB design or optimisation project',
                        'slugs' => [
                            'database-schema',
                            'detailed-report',
                            'documentation',
                            'presentation',
                            'structure-and-flowcharts'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => 'Data analysis and reports',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'extensive lab report or data analysis project for a business problem based on 2-3 datasets',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'source-code'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, simple data analysis project on 1 dataset',
                        'slugs' => [
                            'brief-report',
                            'data-schema-with-explanations',
                            'problem-analysis',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report or data analysis project for a business problem based on 2-3 datasets',
                        'slugs' => [
                            'data-schema-with-explanations',
                            'detailed-report',
                            'presentation',
                            'problem-analysis',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => 'Computer networking and cybersecurity',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'scripts-and-source-code',
                            'short-answers-to-questions',
                            'simple-charts-and-calculations'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'scripts-and-source-code',
                            'short-answers-to-questions',
                            'simple-charts-and-calculations'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, network scheme design, or a simple cybersecurity case',
                        'slugs' => [
                            'brief-report',
                            'models-charts-and-calculations',
                            'scripts-and-source-code'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report, networking or cybersecurity project',
                        'slugs' => [
                            'detailed-report',
                            'models-charts-and-calculations',
                            'presentation',
                            'scripts-and-source-code'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => 'Algorithms',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'simple-charts-and-diagrams',
                            'source-code'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'simple-charts-and-diagrams',
                            'source-code'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, simple algorithm for 1 scenario',
                        'slugs' => [
                            'brief-report',
                            'charts-and-diagrams',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report or algorithm design project',
                        'slugs' => [
                            'charts-and-diagrams',
                            'detailed-report',
                            'documentation',
                            'presentation',
                            'screenshots-of-outputs',
                            'source-code'
                        ],
                        'pricing' => 240
                    ]
                ]
            ],
            [
                'title' => '3D CAD modeling',
                'descriptors' => [
                    TASKSIZE_EXTRA_SMALL => [
                        'example' => 'up to 3 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'simple-operations-and-computations'
                        ],
                        'pricing' => 30
                    ],
                    TASKSIZE_SMALL => [
                        'example' => 'up to 7 short practice problems or theoretical questions',
                        'slugs' => [
                            'screenshots-of-outputs',
                            'short-answers-to-questions',
                            'simple-operations-and-computations'
                        ],
                        'pricing' => 65
                    ],
                    TASKSIZE_MEDIUM => [
                        'example' => 'up to 15 practice problems, small lab report, simple model converted from a drawing',
                        'slugs' => [
                            'brief-report',
                            'screenshots-of-outputs',
                            'simple-3d-cad-model',
                            'simple-operations-and-computations'
                        ],
                        'pricing' => 125
                    ],
                    TASKSIZE_LARGE => [
                        'example' => 'extensive lab report or model develoment from scratch',
                        'slugs' => [
                            '3d-cad-model',
                            'computations',
                            'detailed-report',
                            'documentation',
                            'presentation',
                            'problem-analysis',
                            'screenshots-of-outputs'
                        ],
                        'pricing' => 240
                    ]
                ]
            ]
        );

        foreach($disciplines as $discipline) {
            $disciplineId = (int) Db::getInstance()->getValue('SELECT discipline_id FROM ' . Db::prefix('discipline') . ' WHERE title =  \'' . pSQL($discipline['title']) . '\'');
            $insert = true;
            if($disciplineId) {
                $d = new Discipline( $disciplineId );
                $insert = false;
            } else {
                $d = new Discipline();
            }
            $d->title = $discipline['title'];
            $d->is_academic_writing = false;
            $d->is_complex_assignment = false;
            $d->is_programming = true;

            if($insert) {
                $d->add();
            } else {
                $d->update();
            }

            $descriptors = $discipline['descriptors'];

            foreach($descriptors as $taskSizeId => $descriptor) {
                $descriptorId = (int) Db::getInstance()->getValue('SELECT descriptor_id FROM ' . Db::prefix('descriptor') . ' WHERE discipline_id = ' . (int) $d->id . ' AND task_size_id = ' . (int) $taskSizeId);
                
                $insert = true;
                if($descriptorId) {
                    $desc = new Descriptor( $descriptorId );
                    $insert = false;
                } else {
                    $desc = new Descriptor();
                }

                $desc->discipline_id = $d->id;
                $desc->task_size_id = $taskSizeId;
                $desc->example = $descriptor['example'];
                $desc->is_programming = true;

                if($insert) {
                    $desc->add();
                } else {
                    $desc->update();
                }

                foreach($descriptor['slugs'] as $slug) {
                    $deliverableId = (int) Db::getInstance()->getValue('SELECT deliverable_id FROM ' . Db::prefix('deliverable') . ' WHERE slug =  \'' . pSQL($slug) . '\'');

                    $descriptorDeliverableId = (int) Db::getInstance()->getValue('SELECT descriptor_deliverable_id FROM ' . Db::prefix('descriptor_deliverable') . ' WHERE descriptor_id = ' . (int) $desc->id . ' AND deliverable_id = ' . (int) $deliverableId );

                    if($descriptorDeliverableId) {
                        Db::getInstance()->update(
                            'descriptor_deliverable',
                            array(
                                'descriptor_id' => (int) $desc->id,
                                'deliverable_id' => (int) $deliverableId,
                            ),
                            'descriptor_deliverable_id = ' . (int) $descriptorDeliverableId
                        );
                    } else {
                        Db::getInstance()->insert(
                            'descriptor_deliverable',
                            array(
                                'descriptor_id' => (int) $desc->id,
                                'deliverable_id' => (int) $deliverableId,
                                'date_add' => DateUtils::now()
                            ),
                            false,
                            false,
                            DB::ON_DUPLICATE_KEY
                        );
                    }
                }

                $itemPricingId = (int) Db::getInstance()->getValue('SELECT item_pricing_id FROM ' . Db::prefix('item_pricing') . ' WHERE discipline_id = ' . (int) $d->id . ' AND task_size_id = ' . (int) $taskSizeId);
                $insert = true;
                if($itemPricingId) {
                    $itemPricing = new ItemPricing( $itemPricingId );
                    $insert = false;
                } else {
                    $itemPricing = new ItemPricing();
                }

                $itemPricing->discipline_id = $d->id;
                $itemPricing->task_size_id = $taskSizeId;
                $itemPricing->price = (float) $descriptor['pricing'];
                $itemPricing->is_programming = true;
                $itemPricing->date_add = DateUtils::now();
               
                if($insert) {
                    $itemPricing->add();
                } else {
                    $itemPricing->update();
                }
            }
        }

        $deadlines = array(
            [
                'name' => '4 hours',
                'hrs_customer' => 4,
                'hrs_writer' => 3,
                'price_modifier' => 2.25	
            ],
            [
                'name' => '8 hours',	
                'hrs_customer' => 8,	
                'hrs_writer' => 7,
                'price_modifier' => 1.75	
            ],
            [
                'name' => '24 hours',	
                'hrs_customer' => 24,
                'hrs_writer' => 20,
                'price_modifier' => 1.50	
            ],
            [
                'name' => '48 hours',	
                'hrs_customer' => 48,
                'hrs_writer' => 45,
                'price_modifier' => 1.30	
            ],
            [
                'name' => '3 days',	
                'hrs_customer' => 72,
                'hrs_writer' => 65,
                'price_modifier' => 1.15	
            ],
            [
                'name' => '5 days',	
                'hrs_customer' => 120,
                'hrs_writer' => 100,
                'price_modifier' => 1.05	
            ],
            [
                'name' => '7 days',	
                'hrs_customer' => 168,
                'hrs_writer' => 150,
                'price_modifier' => 1.00	
            ],
            [
                'name' => '14 days',	
                'hrs_customer' => 336,
                'hrs_writer' => 330,
                'price_modifier' => 0.95
            ]
        );

        $sites = Site::getSites();

        foreach($sites as $site) {
            
            foreach($deadlines as $deadline) {
                $deadlineId = (int) Db::getInstance()->getValue('SELECT deadline_id FROM ' . Db::prefix('deadline') . ' WHERE hrs_customer = ' . (int) $deadline['hrs_customer'] . ' AND site_id = ' . (int) $site['site_id'] . ' AND is_programming = 1' );
                $insert = true;
                if($deadlineId) {
                    $siteDeadline = new Deadline( $deadlineId );
                    $insert = false;
                } else {
                    $siteDeadline = new Deadline();
                }
                    
                $siteDeadline->site_id = $site['site_id'];
                $siteDeadline->is_programming = true;
                $siteDeadline->name = $deadline['name'];
                $siteDeadline->price_modifier = (float) $deadline['price_modifier'];
                $siteDeadline->hrs_customer = $deadline['hrs_customer'];
                $siteDeadline->hrs_writer = $deadline['hrs_writer'];

                if($insert) {
                    $siteDeadline->add();
                } else {
                    $siteDeadline->update();
                }
            }
        }
    }
}