<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Database\DbQuery;
use Proxim\Hook;
use Proxim\Module\Module;
use Proxim\Order\Order;
use Proxim\Tools;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;

class PublisherLinks extends Module
{
    public function __construct()
    {
        $this->name = 'publisherlinks';
        $this->icon = 'fas fa-link';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Publisher Links';
        $this->description = 'Add links to where this order was published';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->isLogged() ? true : false;
    }

    public function install()
    {
        if (!parent::install()) {
            return false;
        }

        try {
            Db::getInstance()->Execute("
                ALTER TABLE " . Db::prefix("order") . " ADD (
                    `publish_links` TEXT DEFAULT NULL
                );
            ");
        } catch(Exception $e) {

        }
        
        $this->registerHook(['displayOrderAdditionalInfo']);
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . PROX_ACTIVE_THEME . '/' . $templateName.'.tpl');
    }

    public function hookDisplayOrderAdditionalInfo( $params ) {
        $order_id = ArrayUtils::get($params, 'order_id');

        $order = new Order( (int) $order_id );
        if(Validate::isLoadedObject($order)) {
            $publish_links = Db::getInstance()->getValue('SELECT publish_links FROM ' . Db::prefix('order') . ' WHERE order_id = ' . (int) $order->id );

            if($order->status_id == Order::FINISHED || $publish_links) {
                $this->smarty->assign([
                    'order_id' => $order->id,
                    'publish_links' => $publish_links,
                    'publish_links_html' => Tools::nl2br($publish_links)
                ]);
    
                $this->showTemplate('order.publish_links');
            }
        }

    }

    public function addLinks() {
        $app = $this->application;
        $payload = $app->request->post();

        $order_id = ArrayUtils::get($payload, 'order_id');
        $publish_links = ArrayUtils::get($payload, 'publish_links');

        $order = new Order( (int) $order_id );
        if(!Validate::isLoadedObject($order)) {
            return $app->sendResponse([
                'error' => true,
                'message' => "This order does not exist"
            ]);
        }

        if(!$publish_links) {
            return $app->sendResponse([
                'error' => true,
                'message' => "Please enter at least one url"
            ]);
        }

        Db::getInstance()->update(
            'order',
            ['publish_links' => $publish_links],
            'order_id = ' . (int) $order->id
        );

        return $app->sendResponse([
            'success' => true,
            'message' => "Publish URLs successfuly updated"
        ]);
    }
}