<?php
use Proxim\Application;
use Proxim\Configuration;
use Proxim\Module\Module;
use Proxim\Site\Site;
use Proxim\Util\ArrayUtils;
use Proxim\Validate;

class Rewards_Program extends Module
{
    const REWARDS_PROGRAM_ENABLED = 'REWARDS_PROGRAM_ENABLED';
    const REWARDS_PROGRAM_DISCOUNT = 'REWARDS_PROGRAM_DISCOUNT';

    public function __construct()
    {
        $this->name = 'rewards_program';
        $this->icon = 'fas fa-hands-helping';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = 'Referral & Loyalty Program';
        $this->description = 'Allow your customers to earn rewards through reward points and loyalty program.';
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin ? true : false;
    }

    public function install()
    {
        if (!parent::install()) {
            return false;
        }

        $this->registerHook([
            'displayAdminEditSiteGeneralTabContent',
            'actionAfterSiteSettingsGeneralUpdate'
        ]);
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        $this->application->response()->header('Content-Type', 'text/html; charset=utf-8');
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . PROX_ACTIVE_THEME . '/' . $templateName.'.tpl');
    }

    public function getContent()
    {
        $rewardsProgramValues = Configuration::getMultiple([
            self::REWARDS_PROGRAM_ENABLED,
            self::REWARDS_PROGRAM_DISCOUNT
        ]);

        $this->smarty->assign([
            'rewardsProgramValues' => $rewardsProgramValues
        ]);

        return $this->getTemplateContent('configure');
    }

    public function updateSettings() {
        $app = $this->application;
        $payload = $app->request->post();

        $rewardsProgramDiscount = (float) ArrayUtils::get($payload, 'rewards_program_discount');
        
        Configuration::updateValue(self::REWARDS_PROGRAM_ENABLED, ArrayUtils::has($payload, 'rewards_program_enabled') );
        Configuration::updateValue(self::REWARDS_PROGRAM_DISCOUNT, $rewardsProgramDiscount );

        return $app->sendResponse([
            "success" => true,
			"message" => "System settings have been updated"
        ]);
    }
}