<!-- SecureTrading -->
<div class="tab-pane" id="securetrading">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fas fa-info-circle fa-2x"></i>
        </div>
        <div class="text">
            To start using Secure Trading, you'll need to create an account at <a target="_blank" href="https://www.trustpayments.com/">Secure Trading</a><br>
            Check the documentation for more help
        </div>
    </div>

    <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/{$module_name}/updateSecureTradingSettings">
        <input type="hidden" name="site_id" value="{$secureTradingConfiguration.SITE_ID}"/>
        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">SecureTrading Enabled</div> 
                <div class="form-text">Enable payments via Secure Trading</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="securetrading_enabled"> 
                    <input type="checkbox" name="securetrading_enabled" id="securetrading_enabled" {if $secureTradingConfiguration.SECURETRADING_ENABLED == '1'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>

        <div class="form-table-row"> 
            <div> 
                <div class="form-control-label h5">Default</div> 
                <div class="form-text">Make it the default payment method of the site</div> 
            </div> 
            <div class="text-right"> 
                <label class="switch" for="default_method_enabled"> 
                    <input type="checkbox" name="default_method_enabled" id="default_method_enabled" {if $secureTradingConfiguration.PAYMENT_METHOD_DEFAULT == 'securetrading'}checked{/if}> 
                    <span class="slider round"></span> 
                </label> 
            </div> 
        </div>
        
        <div class="form-group form-row">
            <label class="col-sm-3 control-label text-left">
                Site Reference Code
            </label>
            <div class="col-sm-9">
                <input class="form-control" type="text" name="securetrading_reference" id="securetrading_reference" maxlength="255" value="{$secureTradingConfiguration.SECURETRADING_REFERENCE}">
                <span class="help-block">Secure Trading Site Reference Code
            </div>
        </div>

        <div class="form-group form-row">
            <div class="col-sm-9 offset-sm-3">
                <!-- success -->
                <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                <!-- success -->

                <!-- error -->
                <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                <!-- error -->

                <button type="submit" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </form>
</div>
<!-- SecureTrading -->