<?php 
use Proxim\Application;
use Proxim\Hook;
use Proxim\Module\Module;
use Proxim\Order\Order;
use Proxim\User\Employee;
use Proxim\Util\ArrayUtils;
use Proxim\Util\DateUtils;
use Proxim\Validate;

class Skip_Editor extends Module
{
    public function __construct()
    {
        $this->name = 'skip_editor';
        $this->icon = 'fa fa-addon';
        $this->version = '1.0.0';
        $this->prox_versions_compliancy = array('min' => '1.0.0', 'max' => PROX_VERSION);
        $this->author = 'Davison Pro';
        $this->displayName = 'Skip Editor';
        $this->description = 'Allow specific writers to submit orders directly to delivered without the editing process';

        $this->bootstrap = true;
        parent::__construct();
    }

    public function checkAccess() {
        $user = $this->application->user;
        return $user->is_admin ? true : false;
    }

    public function install()
    {
        
        if (!parent::install()) {
            return false;
        }

        if (!$this->createTables()) {
            return false;
        }

        $this->registerHook('displayAdminEditEmployeeAccount') &&
            $this->registerHook('actionOrderCompleted') &&
                $this->registerHook('actionEmployeeEdited');
    }

    public function createTables() {
        $result = Db::getInstance()->getRow("SELECT * FROM ". Db::prefix('employee'));
        if(!isset($result['is_skip_editor'])) {
            if (!Db::getInstance()->Execute("
                ALTER TABLE " . Db::prefix('employee') . " ADD (
                    `is_skip_editor` TINYINT(1) NOT NULL DEFAULT '0'
                );
            ")) {
                return false;
            }
        }

        return true;
    }

    /**
     * Echoes a template.
     *
     * @param string $templateName Template name
     */
    public function showTemplate($templateName)
    {
        echo $this->getTemplateContent($templateName);
    }

    /**
     * Return a template.
     *
     * @param string $templateName          Template name
     * @param array  $additionnalParameters Additionnal parameters to inject on the Twig template
     *
     * @return string Parsed template
     */
    private function getTemplateContent($templateName, $additionnalParameters = array())
    {
        $this->smarty->assign($additionnalParameters);
        return $this->fetch(__DIR__ . '/views/' . PROX_ACTIVE_THEME . '/' . $templateName.'.tpl');
    }

    public function hookDisplayAdminEditEmployeeAccount($params) {
        $smarty = $this->smarty;
        $employee_id = (int) ArrayUtils::get($params, 'employee_id');

        $employee = new Employee((int) $employee_id);
        if(Validate::isLoadedObject($employee) && $employee->is_writer) {
            $skip_editor = (bool) Db::getInstance()->getValue('SELECT is_skip_editor FROM ' . Db::prefix('employee') . ' WHERE employee_id = ' . (int) $employee->id );

            $smarty->assign([
                'skip_editor' => $skip_editor
            ]);
    
            return $this->showTemplate('form.control');
        }
    }

    public function hookActionEmployeeEdited($params) {
        $app = $this->application;
        $payload = $app->request->post();
        $employee = ArrayUtils::get($params, 'employee');

        if( Validate::isLoadedObject($employee) ) {
            Db::getInstance()->update(
                'employee',
                [
                    'is_skip_editor' => (bool) ArrayUtils::has($payload, 'skip_editor')
                ],
                'employee_id = ' . (int) $employee->id
            );
        }
    }

    public function hookActionOrderCompleted($params) {
        $app = $this->application;
        $controller = $app->controller;
        $order = ArrayUtils::get($params, 'order');

        if( Validate::isLoadedObject($order) ) {
            $skip_editor = (bool) Db::getInstance()->getValue('SELECT is_skip_editor FROM ' . Db::prefix('employee') . ' WHERE employee_id = ' . (int) $order->writer_id );
            if($skip_editor) {
                $order->deliverOrderToCustomer();
    
                $app->sendResponse([
                    'callback' => 'window.location.reload();'
                ]);	
                return false;
            }
        }
    }
}