<?php
/**
 * @package    Proxim
 * @author     Davison Pro <davis@davisonpro.dev | https://davisonpro.dev>
 * @copyright  2019 Proxim
 * @version    1.5.0
 * @since      File available since Release 1.0.0
 */

namespace Proxim\PDF;

use Proxim\Application;
use Proxim\Site\Site;
use Proxim\Tools;
use Proxim\Util\DateUtils;

/**
 * @since 1.5
 */
class HTMLTemplateTransactionsList extends HTMLTemplate
{
    public $application;

    public $transactions;

    /**
     * @param $transactions
     * @param $smarty
     *
     * @throws Exception
     */
    public function __construct($transactions, $smarty)
    {
        $this->application = Application::getInstance();

        $this->transactions = $transactions;

        $this->smarty = $smarty;

        $this->title = 'Transactions';

        $site = $this->application->site;
        $this->site = new Site((int) $site->id );
    }

    /**
     * Use this method to return the result of a smarty template when assign data only locally with $this->smarty->assign().
     *
     * @param string $templatePath relative path the template file, from the module root dir
     *
     * @return mixed
     */
    public function fetch($templatePath)
    {
        $template = $this->application->smarty->createTemplate(
            $templatePath,
            $this->smarty
        );

        return $template->fetch();
    }

    public function getTemplate($template_name) {
        $template = false;
        $default_template = rtrim(CURRENT_TRX_MODULE_DIR, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR  . 'pdf' . DIRECTORY_SEPARATOR . $template_name . '.tpl';
        if (file_exists($default_template)) {
            $template = $default_template;
        } 

        return $template;
    }

    /**
     * Returns the template's HTML content.
     *
     * @return string HTML content
     */
    public function getContent()
    {
        $this->smarty->assign([
            'trx' => $this->transactions,
            'style_tab' => $this->fetch($this->getTemplate('transactions.style-tab'))
        ]);

        return $this->fetch($this->getTemplate('transactions'));
    }

    /**
     * Returns the template filename.
     *
     * @return string filename
     */
    public function getFilename()
    {
        return sprintf('TRX%06d', DateUtils::now()) . '.pdf';
    }

    /**
     * Returns the template filename when using bulk rendering.
     *
     * @return string filename
     */
    public function getBulkFilename()
    {
        return 'transactions.pdf';
    }

    /**
     * Returns the template's HTML header.
     *
     * @return string HTML header
     */
    public function getHeader()
    {
        $this->assignCommonHeaderData();
        $this->smarty->assign(['header' => 'Transactions']);
        return $this->fetch($this->getTemplate('header'));
    }
}