{$style_tab nofilter}

<table class="product" width="100%" cellpadding="4" cellspacing="0">
    <thead>
        <tr>
            <th class="product header small" width="20%">Node Type</th>
            <th class="product header small" width="15%">Node ID</th>
            <th class="product header-right small" width="20%">Payment Method</th>
            <th class="product header-right small" width="20%">Date</th>
            <th class="product header-right small" width="25%">Amount</th>
        </tr>
    </thead>

    <tbody>
        {if count($trx.transactions) == 0}
            <tr class="product" colspan="4">
                <td class="product center">No transactions</td>
            </tr>
        {else}
            {foreach $trx.transactions as $transaction}
                {cycle values=["color_line_even", "color_line_odd"] assign=bgcolor_class}
                <tr class="product {$bgcolor_class}">
                    <td class="product left">
                        {$transaction.node_type|ucfirst}
                    </td>
                    
                    <td class="product left bold">
                        {$transaction.node_id}
                    </td>

                    <td class="product left">
                        {if $transaction.payment_method}{$transaction.payment_method|ucfirst}{else}N/A{/if}
                    </td>

                    <td class="product left">
                        {$transaction.date_add|date_format}
                    </td>
                    
                    <td class="product bold right text-success">
                        {$transaction.amountFormatted}
                    </td>
                </tr>
            {/foreach}
        {/if}

    </tbody>

    <tfoot class="product">
        {foreach $trx.amounts as $amount}
            <tr class="separator">
                <th class="right bold" align="right" colspan="4">{$amount.iso_code}:</th>
                <td class="right text-success bold">{$amount.amountFormatted}</td>
            </tr>
        {/foreach}
    </tfoot>

</table>


