<!-- Transactions -->
<form method="GET" class="mb20" autocomplete="off">
    <div class="row">

        <div class="form-group col-md-3">
            <select class="form-control" name="payment_method">
                <option value="0" {if !$selected_payment_method}selected="selected"{/if}>Payment Method</option>
                {foreach $payment_methods as $payment_method}
                    <option value="{$payment_method.name}" {if $payment_method.name == $selected_payment_method}selected="selected"{/if}>{$payment_method.name|ucfirst}</option>
                {/foreach}
            </select>
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="from" data-target-input="nearest">
                <input type='text' class="form-control datetimepicker-input" placeholder="From" value="{$date_from}" data-target="#from" name="from" />
                <div class="input-group-append" data-target="#from" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-3">
            <div class="input-group date js_datetimepicker" id="to" data-target-input="nearest">
                <input type='text' class="form-control datetimepicker-input" placeholder="To" value="{$date_to}" data-target="#to" name="to" />
                <div class="input-group-append" data-target="#to" data-toggle="datetimepicker">
                    <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                </div>
            </div>
        </div>

        <div class="form-group col-md-3">
            <button type="submit" name="search" class="btn btn-primary"><i class="fa fa-search mr5"></i>Search</button>
            <button type="submit" name="export" class="btn btn-success"><i class="fas fa-file-export mr5"></i>Export</button>
        </div>
    </div>
</form> 

{if count($transactions)}
    <div class="table-responsive">
        <table class="table table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>Type</th>
                    <th>Node ID</th>
                    <th>Payment Method</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $transactions as $transaction}
                    <tr>
                        <td>{$transaction.node_type|ucfirst}</td>
                        <td>
                            {if $transaction.node_type == "order" ||  $transaction.node_type == "add-payment" || $transaction.node_type == "tip"}
                                <strong>
                                    <a href="{$base_uri}/order/{$transaction.node_id}" data-ajax="/order/{$transaction.node_id}">#{$transaction.node_id}</a>
                                </strong>
                            {elseif $transaction.node_type == "paper"}
                                <strong>
                                    <a href="{$base_uri}/prepapers/viewPaper?paperId={$transaction.node_id}" data-ajax="/prepapers/viewPaper?paperId={$transaction.node_id}">#{$transaction.node_id}</a>
                                </strong>
                            {elseif $transaction.node_type == "wallet"}
                                <strong>
                                    <a href="{$base_uri}/customers/edit/{$transaction.node_id}" data-ajax="/customers/edit/{$transaction.node_id}">#{$transaction.node_id}</a>
                                </strong>
                            {/if}
                        </td>
                        <td>{if $transaction.payment_method}{$transaction.payment_method|ucfirst}{else}N/A{/if}</td>
                        <td>{$transaction.amountFormatted}</td>
                        <td>
                            <span class="js_moment" data-time="{$transaction.date_add}">{$transaction.date_add}</span>
                        </td>
                        <td>
                            {if $transaction.node_type == "order" ||  $transaction.node_type == "add-payment" || $transaction.node_type == "tip"}
                                <a class="btn btn-info btn-sm" href="{$base_uri}/order/{$transaction.node_id}" data-ajax="/order/{$transaction.node_id}"> 
                                    <i class="fa fa-eye"></i> View
                                </a>
                            {elseif $transaction.node_type == "paper"}
                                <a class="btn btn-info btn-sm" href="{$base_uri}/prepapers/viewPaper?paperId={$transaction.node_id}" data-ajax="/prepapers/viewPaper?paperId={$transaction.node_id}"> 
                                    <i class="fa fa-eye"></i> View
                                </a>
                            {elseif $transaction.node_type == "wallet"}
                                <a class="btn btn-info btn-sm" href="{$base_uri}/customers/edit/{$transaction.node_id}" data-ajax="/customers/edit/{$transaction.node_id}"> 
                                    <i class="fa fa-eye"></i> View
                                </a>
                            {/if}
                        </td>
                    </tr>
                {/foreach}
            </tbody>
            <tfoot>
                {foreach $amounts as $amount}
                    <tr style="display: table-row;">
                        <th class="text-right" align="right" colspan="3">{$amount.iso_code}:</th>
                        <td class="text-right">
                            <strong class="text-success">{$amount.amountFormatted}</strong>
                        </td>
                    </tr>
                {/foreach}
            </tfoot>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
        <p class="mb10"><strong>No transactions to show</strong></p>
    </div>
{/if}
<!-- Transactions -->