<div class="nk-block-head nk-block-head-sm">
    <div class="nk-block-between">
        <div class="nk-block-head-content">
            <h3 class="nk-block-title page-title">Reviews</h3>
            <div class="nk-block-des text-soft">
                <p>You have total {pluralize('review', $total_reviews)}</p>
            </div>
        </div>
        <!-- .nk-block-head-content -->

        <div class="nk-block-head-content">
            <div class="toggle-wrap nk-block-tools-toggle">
                <a href="javascript:void(0);" class="btn btn-icon btn-trigger toggle-expand mr-n1" data-target="more-options"><em class="icon ni ni-more-v"></em></a>
                <div class="toggle-expand-content" data-content="more-options">
                    <ul class="nk-block-tools g-3">
                        <li class="nk-block-tools-opt">
                            <a href="javascript:void(0);" class="btn btn-icon btn-secondary d-md-none" data-toggle="modal" data-url="#trustpilotSettings">
                                <em class="icon ni ni-setting"></em>
                            </a>
                            <a href="javascript:void(0);" class="btn btn-secondary d-none d-md-inline-flex" data-toggle="modal" data-url="#trustpilotSettings">
                                <em class="icon ni ni-setting"></em><span>Settings</span>
                            </a>
                        </li>
                        <li class="nk-block-tools-opt">
                            <a href="javascript:void(0);" class="btn btn-icon btn-primary d-md-none" data-toggle="modal" data-url="#addTrustpilotReview">
                                <em class="icon ni ni-plus"></em>
                            </a>
                            <a href="javascript:void(0);" class="btn btn-primary d-none d-md-inline-flex" data-toggle="modal" data-url="#addTrustpilotReview">
                                <em class="icon ni ni-plus"></em><span>Add Review</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- .nk-block-head-content -->
    </div>
    <!-- .nk-block-between -->
</div>

<div class="nk-block">
    {if count($reviews)}
        <div class="row mt-2 mb-4">
            {foreach $reviews as $review}
                <div class="col-sm-6 col-lg-4 mb-4"> 
                    <div class="card h-100">
                        <div class="card-inner">
                            <div class="d-flex justify-content-between align-items-start mb-3">
                                <div class="d-flex align-items-center">
                                    <div class="ml-0">
                                        <h6 class="title mb-1">{$review['author_name']}</h6>
                                        <span class="sub-text js_moment" data-time="{$review['time']}">{$review['time']}</span>
                                        <div class="Rating Rating--large Rating--labeled" data-star_rating="{$review['stars_formatted']}">
                                            <span class="Rating-total">
                                                <span class="Rating-progress"></span>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="dropdown">
                                    <a href="#" class="dropdown-toggle btn btn-sm btn-icon btn-trigger mt-n1 me-n1" data-toggle="dropdown" aria-expanded="false">
                                        <em class="icon ni ni-more-h"></em>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-end">
                                        <ul class="link-list-opt no-bdr">
                                            <li>
                                                <a data-toggle="modal" href="#" data-url="#modalEditReview" data-options='{$review|json_encode nofilter}'>
                                                    <em class="icon ni ni-edit"></em>
                                                    <span>Edit Review</span>
                                                </a>
                                            </li>
                                            <li>
                                                <a data-toggle="modal" href="#" class="js_deleter" data-handle="trustpilot_review" data-id="{$review.review_id}">
                                                    <em class="icon ni ni-delete"></em>
                                                    <span>Delete Review</span>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <h6 class="title mb-1">{$review['title']}</h6>
                            <p>{$review['body_formatted'] nofilter}</p>
                        </div>
                    </div>
                </div>
            {/foreach}
        </div>

        {$pager nofilter}
    {else}
        <div class="text-center x-muted"> 
            <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
            <h6 class="text-dark title mb-3">No reviews to show</h6>
        </div> 
    {/if}
</div>

<script id="addTrustpilotReview" type="text/template">
    <form class="js_ajax-forms mb10" data-url="/trustpilot/postReview" method="POST" autocomplete="OFF">
    <div class="modal-header">
            <h5 class="modal-title">Add Review</h5>
            <a href="#" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Author Name</label>
                <input class="form-control form-control-lg" name="author_name" placeholder="Jane Doe">
            </div>

            <div class="form-group">
                <label class="form-label">Review Title</label>
                <input class="form-control form-control-lg" name="review_title" placeholder="Amazing service!!!">
            </div>

            <div class="form-group">
                <label class="form-label">Review</label>
                <textarea class="form-control form-control-lg js_autosize" name="review_body"></textarea>
            </div>

            <div class="form-group form-row">
                <div class="col-md-6">
                    <label class="form-label">Review Stars</label>
                    <div class="form-control-wrap">
                        <div class="form-icon lg form-icon-left">
                            <em class="icon ni ni-star"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg force-integer" name="review_stars" min="1" max="5">
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Date</label>
                    <div class="form-control-wrap">
                        <div class="form-icon lg form-icon-right">
                            <em class="icon ni ni-calendar-alt"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg date-time-picker" name="date_time" id="date_time">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Publish</button>
        </div>
    </form>
</script>

<script id="modalEditReview" type="text/template">
    <form class="js_ajax-forms mb10" data-url="/trustpilot/postReview" method="POST" autocomplete="OFF">
        <input type="hidden" name="review_id" value="{literal}{{review_id}}{/literal}">

        <div class="modal-header">
            <h5 class="modal-title">Edit Review</h5>
            <a href="#" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <label class="form-label">Author Name</label>
                <input class="form-control form-control-lg" name="author_name" placeholder="Jane Doe" value="{literal}{{author_name}}{/literal}">
            </div>

            <div class="form-group">
                <label class="form-label">Review Title</label>
                <input class="form-control form-control-lg" name="review_title" placeholder="Amazing service!!!" value="{literal}{{title}}{/literal}">
            </div>

            <div class="form-group">
                <label class="form-label">Review</label>
                <textarea class="form-control form-control-lg js_autosize" name="review_body">{literal}{{body}}{/literal}</textarea>
            </div>

            <div class="form-group form-row">
                <div class="col-md-6">
                    <label class="form-label">Review Stars</label>
                    <div class="form-control-wrap">
                        <div class="form-icon lg form-icon-left">
                            <em class="icon ni ni-star"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg force-integer" name="review_stars" min="1" max="5" value="{literal}{{stars}}{/literal}">
                    </div>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Date</label>
                    <div class="form-control-wrap">
                        <div class="form-icon lg form-icon-right">
                            <em class="icon ni ni-calendar-alt"></em>
                        </div>
                        <input type="text" class="form-control form-control-lg date-time-picker" name="date_time" id="date_time" value="{literal}{{time}}{/literal}">
                    </div>
                </div>
            </div>

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Update Review</button>
        </div>
    </form>
</script>

<script id="trustpilotSettings" type="text/template">
    <form class="js_ajax-forms mb10" data-url="/trustpilot/updateTrustpilotSettings" method="POST" autocomplete="OFF">
        <div class="modal-header">
            <h5 class="modal-title">Configure</h5>
            <a href="#" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">
            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h6 fw-500">Custom Reviews</div> 
                    <div class="form-text">Display custom reviews in the order from</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="trustpilot_show_reviews"> 
                        <input type="checkbox" name="trustpilot_show_reviews" id="trustpilot_show_reviews" {if $trustpilotConfiguration.TRUSTPILOT_SHOW_REVIEWS}checked{/if}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>
            <div class="form-group">
                <label class="form-label">Trustpilot Rating Title</label>
                <input class="form-control form-control-lg" name="trustpilot_title" placeholder="Excellent" value="{$trustpilotConfiguration.TRUSTPILOT_TITLE}">
            </div>

            <div class="form-group">
                <label class="form-label">Trustpilot Star Rating</label>
                <input class="form-control form-control-lg" name="trustpilot_stars" value="{$trustpilotConfiguration.TRUSTPILOT_STARS}">
            </div>

            <div class="form-group">
                <label class="form-label">Trustpilot Total Reviews</label>
                <input class="form-control form-control-lg" name="trustpilot_reviews" value="{$trustpilotConfiguration.TRUSTPILOT_REVIEWS}">
            </div>

            <div class="form-group">
                <label class="form-label">Trustpilot Link</label>
                <input class="form-control form-control-lg" name="trustpilot_link" placeholder="https://www.trustpilot.com/review/example.com" value="{$trustpilotConfiguration.TRUSTPILOT_LINK}">
            </div>

            <div class="form-group">
                <!-- error -->
                <div class="alert alert-danger alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-cross-circle"></em> <span></span></div>
                <!-- error -->

                <!-- success -->
                <div class="alert alert-success alert-fill alert-icon x-hidden mb-0"><em class="icon ni ni-check"></em> <span></span></div>
                <!-- success -->
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
    </form>
</script>