{if $_settings == 'two-factor'}
<form class="js_ajax-forms" data-url="/two_factor_auth/updateProfileSettings" autocomplete="off">    
    <input type="hidden" name="type" value="{$two_factor_type}">
    <div class="alert alert-info">
        <div class="icon">
            <i class="fa fa-shield-alt fa-2x"></i>
        </div>
        <div class="text">
            <strong>Two-Factor Authentication</strong><br>
            Log in with a code from your 
            {if $two_factor_type == "email"}email{/if} 
            {if $two_factor_type == "sms"}phone{/if} 
            {if $two_factor_type == "google"}Google Authenticator App{/if} 
            as well as a password
        </div>
    </div>

    {if !$userData.two_factor_enabled && $two_factor_type == "google"}
        <div class="heading-small mb20">
            Configuring your authenticator
        </div>
        <div class="pl-md-4">
            <ol class="mtb20">
                <li class="mb5">
                    You need to download Google Authenticator app for <a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en">Android</a> or <a target="_blank" href="https://itunes.apple.com/eg/app/google-authenticator/id388497605?mt=8">IOS</a>
                </li>
                <li>
                    In your app, add a new account using the details below:
                </li>
            </ol>

            <div class="row text-center">
                <div class="form-group col-md-6">
                    <h6 class="h5 fw-bold">Scanning the QR code</h6>
                    <img src="{$two_factor_QR}">
                </div>
                <div class="form-group col-md-6">
                    <h6 class="h5 fw-bold">Manually by entering this token</h6>
                    <h3>
                        <span class="alert alert-warning fw-bold pt10 pb10 pl20 pr20 h4">{$two_factor_gsecret}</span>
                    </h3>
                </div>
            </div>
        </div>
        <div class="heading-small mb20">
            Activate your authenticator
        </div>
        <div class="pl-md-4">
            <div class="form-group form-row">
                <label class="col-md-3 form-control-label">
                    Verification Code
                </label>
                <div class="col-md-9">
                    <input name="gcode" type="text" class="form-control" placeholder="######" required autofocus>
                    <span class="form-text">
                        Enter the code shown on your app
                    </span>
                </div>
            </div>
        </div>
    {else}
        <div class="form-table-row">
            <div>
                <div class="form-control-label h5">Two-Factor Authentication</div>
                <div class="form-text">Enable two-factor authentication to log in with a code from your email/phone as well as a password</div>
            </div>
            <div class="text-right">
                <label class="switch" for="two_factor_enabled">
                    <input type="checkbox" name="two_factor_enabled" id="two_factor_enabled" {if $userData.two_factor_enabled}checked{/if}>
                    <span class="slider round"></span>
                </label>
            </div>
        </div>
    {/if}
    <div class="form-group">
        <!-- success -->
        <div class="alert alert-success x-hidden"></div>
        <!-- success -->

        <!-- error -->
        <div class="alert alert-danger x-hidden"></div>
        <!-- error -->

        <button type="submit" class="btn btn-primary">Save Changes</button>
    </div>
</form>
{/if}