<div class="tab-pane" id="wallet">
    <div class="nk-block-head">
        <div class="nk-block-between d-flex justify-content-between">
            <div class="nk-block-head-content">
                <h4 class="nk-block-title">Wallet</h4>
                <div class="nk-block-des">
                    <p>Basic info, like your name and address, that you use on {$customer.site_name}.</p>
                </div>
            </div>
        </div>
    </div><!-- .nk-block-head -->

    <div class="nk-block">
        <div class="user-account-info mb-4 py-0">
            <h6 class="overline-title-alt">Wallet Balance</h6>
            <h4 class="user-balance">
                {formatPrice($customerWallet.wallet_balance)} <small class="currency currency-btc">USD</small>
            </h4>
            <div class="mt-2">
                <button data-toggle="modal" data-size="small" data-url="#modalLoadWallet" class="btn btn-primary">
                    <em class="icon ni ni-wallet-in"></em> <span>Load Funds</span>
                </button>
                <button data-toggle="modal" data-size="small" data-url="#modalEditWallet" class="btn btn-secondary">
                    <em class="icon ni ni-wallet-saving"></em> <span>Edit Balance</span>
                </button>
            </div>
        </div>
        
        {if count($transactions)}
            <div class="border round">
                <table class="table table-tranx is-compact">
                    <thead>
                        <tr class="tb-tnx-head">
                            <th class="tb-tnx-info">Type</th>
                            <th class="tb-tnx-info">Amount</th>
                            <th class="tb-tnx-info">Date</th>
                        </tr>
                    </thead>
                    <tbody class="tb-tnx-body">
                        {foreach $transactions as $transaction}
                            <tr class="tb-tnx-item">
                                <td class="tb-tnx-info">
                                    {$transaction.source|ucfirst} {if $transaction.wallet_in}{$transaction.payment_method|ucfirst}{/if}
                                </td>
                                <td class="tb-tnx-info">
                                    <span class="{if $transaction.wallet_in}text-success{else}text-danger{/if}">
                                        {if $transaction.wallet_in}+{else}-{/if} {$transaction.amountFormatted}
                                    </span>
                                </td>
                                <td class="tb-tnx-info">
                                    <span class="js_moment" data-time="{$transaction.date}">{$transaction.date}</span>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {else}
            <div class="text-center x-muted"> 
                <img class="mb-3" width="15%" src="{$theme_uri}/images/no_results.png">
                <h6 class="text-dark title mb-3">No transactions to show</h6>
            </div>
        {/if}
    </div>
</div>

<!-- Modal Load Wallet -->
<script id="modalLoadWallet" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/wallet/loadWallet" method="POST">
        <input name="customer_id" type="hidden" value="{$customer_id}"/>
        <div class="modal-header">
            <h5 class="modal-title">Load Funds</h5>
            <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">

            <div class="form-group">
                <label class="form-label text-left">Amount</label>
                <div class="input-group">
                    <div class="input-group-prepend"> 
                        <span class="input-group-text">$</span> 
                    </div>
                    <input name="amount" type="text" class="form-control form-control-lg force-integer" autocomplete="off">
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success alert-fill mb-0 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill mb-0 x-hidden" role="alert"></div>
            <!-- error -->

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Confirm</button>
        </div>
    </form>
</script>
<!-- Modal Load Wallet -->

<!-- Modal Edit Wallet -->
<script id="modalEditWallet" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/wallet/editWalletBalance" method="POST">
        <input name="customer_id" type="hidden" value="{$customer_id}"/>
        <div class="modal-header">
            <h5 class="modal-title">Edit Balance</h5>
            <a href="javascript:void(0);" class="close" data-dismiss="modal" aria-label="Close">
                <em class="icon ni ni-cross"></em>
            </a>
        </div>
        <div class="modal-body">

            <div class="form-group">
                <label class="form-label text-left">Amount</label>
                <div class="input-group">
                    <div class="input-group-prepend"> 
                        <span class="input-group-text">$</span> 
                    </div>
                    <input name="amount" type="text" class="form-control form-control-lg force-integer" autocomplete="off" value="{$customerWallet.wallet_balance}">
                </div>
            </div>

            <!-- success -->
            <div class="alert alert-success alert-fill mb-0 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger alert-fill mb-0 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Modal Edit Wallet -->

