<div class="tab-pane" id="wallet">
    <div class="row mb10">
        <div class="col-sm-4">
            <div class="stat-panel bg-gradient-primary">
                <div class="stat-cell">
                    <i class="fa fa-dollar-sign bg-icon"></i>
                    <span class="text-xlg">{formatPrice($customerWallet.wallet_balance)}</span><br>
                    <span class="text-lg">Balance</span><br>
                </div>
            </div>

            <button data-toggle="modal" data-size="small" data-url="#modalLoadWallet" class="btn btn-primary">
                <i class="fa fa-plus"></i> Load Funds
            </button>
            <button data-toggle="modal" data-size="small" data-url="#modalEditWallet" data-options='{literal}{{/literal}"wallet_balance":{$wallet_balance}{literal}}{/literal}' class="btn btn-default">
                <i class="fas fa-edit"></i> Edit Balance
            </button>
        </div>
    </div>

    {if count($transactions)}
        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover js_dataTable">
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $transactions as $transaction}
                        <tr>
                            <td>
                                {$transaction.source|ucfirst} {if $transaction.wallet_in}{$transaction.payment_method|ucfirst}{/if}
                            </td>
                            <td>
                                <span class="{if $transaction.wallet_in}text-success{else}text-danger{/if}">
                                    {if $transaction.wallet_in}+{else}-{/if} {$transaction.amountFormatted}
                                </span>
                            </td>
                            <td><span class="js_moment" data-time="{$transaction.date}">{$transaction.date}</span></td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>

    {else}
        <div class="text-center x-muted"> 
            <img class="mb20" width="15%" src="{$theme_uri}/images/no_results.png">
            <p class="mb10"><strong>No transactions to show</strong></p>
        </div>
    {/if}
</div>

<!-- Modal Load Wallet -->
<script id="modalLoadWallet" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/{$module_name}/loadWallet" method="POST">
        <input name="customer_id" type="hidden" value="{$customer_id}"/>
        <div class="modal-header">
            <h5 class="modal-title">Load Funds</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>
        <div class="modal-body">

            <div class="form-group form-row">
                <label class="control-label text-left">Amount</label>
                <div class="input-group">
                    <div class="input-group-prepend"> 
                        <span class="input-group-text">$</span> 
                    </div>
                    <input name="amount" type="text" class="form-control force-integer" autocomplete="off">
                </div>
            </div>
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Confirm</button>
        </div>
    </form>
</script>
<!-- Modal Load Wallet -->

<!-- Modal Edit Wallet -->
<script id="modalEditWallet" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/{$module_name}/editWalletBalance" method="POST">
        <input name="customer_id" type="hidden" value="{$customer_id}"/>
        <div class="modal-header">
            <h5 class="modal-title">Edit Balance</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>
        <div class="modal-body">

            <div class="form-group form-row">
                <label class="control-label text-left">Amount</label>
                <div class="input-group">
                    <div class="input-group-prepend"> 
                        <span class="input-group-text">$</span> 
                    </div>
                    <input name="amount" type="text" class="form-control force-integer" autocomplete="off" value="{literal}{{wallet_balance}}{/literal}">
                </div>
            </div>
            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Modal Edit Wallet -->

