{block name='head_charset'}
    <meta charset="utf-8">
{/block}

{block name='head_seo'}
	<title>{block name='head_seo_title'}{$page_title}{/block}</title>
	{if $site_favicon}
		<link rel="shortcut icon" href="{$uploads_path}/{$site_favicon}" />
	{/if}
{/block}

{block name='head_ie_compatibility'}
    <meta http-equiv="x-ua-compatible" content="ie=edge">
{/block}

{block name='head_viewport'}
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0">
{/block}

<!-- Fonts [Lato|Font-Awesome] -->
<link href="https://fonts.googleapis.com/css?family=Lato:300,300i,400,600,600i,400i,700,700i,900&display=swap" rel="stylesheet"> 
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.12.1/css/all.css">
<!-- Fonts [Lato|Font-Awesome] -->

{block name='stylesheets'}
    {include file="_partials/stylesheets.tpl" stylesheets=$stylesheets}
{/block}

<!-- Dependencies Libs [jQuery|Bootstrap] -->
<script src="https://code.jquery.com/jquery-3.4.1.min.js" integrity="sha256-CSXorXvZcTkaix6Yvo6HppcZGetbYMGWSFlBw8HfCJo=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js" integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6" crossorigin="anonymous"></script> 
<!-- Dependencies Libs [jQuery|Bootstrap] -->

<!-- jQuery-UI -->
<script>var _tooltip = jQuery.fn.tooltip;</script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js" integrity="sha256-VazP97ZCwtekAsvgPBSUwPFKdrwD3unUfSGVYrahUqU=" crossorigin="anonymous"></script>
<script>jQuery.fn.tooltip = _tooltip;</script>
<!-- jQuery-UI -->

{block name='javascript_head'}
    {include file="_partials/javascript.tpl" javascript=$javascript.head vars=$js_custom_vars}
{/block}

{strip}

{if $css_customize}
	<style type="text/css">

    {if $color_button_primary}
		.btn-primary, .btn-primary:focus, .btn-primary:hover {
			background: {$color_button_primary}!important;
			border-color: {$color_button_primary}!important;
		}
	{/if}

    {if $header_color}
        .main-header {
            background: {$header_color};
        }
        
        .main-header .user-menu {
            border-left-color: {$header_color};
        }
    {/if}

    {if $menu_background}
		.main-header .nav .open>a.user-menu, 
		.main-header .nav .open>a.user-menu:hover, 
		.main-header .nav .open>a.user-menu:focus {
			background: {$menu_background};
			border-color: {$menu_background};
		}
		
		.dropdown-menu>li>a:hover, .dropdown-menu>li>a:focus,
		.nav-home.nav-pills>li.active>a, 
		.nav-home.nav-pills>li.active>a:hover, 
		.nav-home.nav-pills>li.active>a:focus {
			background: {$menu_background};
		}
	{/if}

    {$custom_css nofilter}

    </style>
{/if}

{if isset($css_files)}
	{foreach from=$css_files key=css_uri item=media}
		<link href="{$css_uri|escape:'html':'UTF-8'}" rel="stylesheet" type="text/css"/>
	{/foreach}
{/if}

{/strip}