<div class="main-header">
	<div class="container header-container">
		<div class="brand-container hidden-xs">
			<a href="{$base_uri}" class="brand"> 
				{if $site_logo}
					<img height="45" src="{$uploads_path}/{$site_logo}" alt="{$site_name}" title="{$site_name}"> 
				{else}
					{$site_name}
				{/if}
			</a>
		</div>

		<div class="navbar-container">
			<ul class="nav navbar-nav">
				{if $user.logged}
					<li class="visible-xs-block">
						<a href="#" data-toggle="offcanvas" data-target=".sidebar-nav"> 
							<i class="fa fa-bars fa-lg"></i> 
						</a>
					</li>

					<!-- messages -->
					{include file='_partials/_header.messages.tpl'}
					<!-- messages -->

					<!-- notifications -->
					{include file='_partials/_header.notifications.tpl'}
					<!-- notifications -->

					<li class="dropdown">
						<a href="{$base_uri}/orders" class="dropdown-toggle user-menu" data-toggle="dropdown"> 
							<img src="{$user.user_picture}" alt="{$user.first_name} {$user.last_name}" title="{$user.first_name} {$user.last_name}"> 
							<span class="hidden-xs">{$user.first_name} {$user.last_name}</span> 
							<i class="caret"></i> 
						</a>
						<div class="dropdown-menu dropdown-menu-right">
							{if $user.is_writer || $user.is_editor}
								<a class="dropdown-item" href="{$base_uri}/financial-overview">Outstanding <span class="badge badge-success pull-right">{$user_outstanding_balance}</span></a> 
							{/if}

							<a class="dropdown-item" href="{$base_uri}/profile">Settings</a> 
							<a class="dropdown-item" href="{$base_uri}/orders/available">Manage Orders</a> 

							{if $user.is_admin}
								<a class="dropdown-item" href="{$base_uri}/updates">
									Check for Updates {if $new_version}<span class="badge badge-pill badge-success pull-right">New</span>{/if}
								</a> 
							{/if}
							
							{if $isAuthorize}
								<a class="dropdown-item" href="{$base_uri}/authorize/{$admin.id}/{$admin.secure_key}">Back to Administrator</a> 
							{/if}
							<div class="dropdown-divider"></div>
							<a class="dropdown-item" href="{$base_uri}/logout">Log Out</a> 
							<div class="dropdown-divider"></div>
							{if $theme_mode_night}
								<div class="dropdown-item pointer js_theme-mode" data-mode="day">
									<span class="js_theme-mode-text">Day Mode</span>
									<span class="pull-right">
										<i class="js_theme-mode-icon fas fa-sun"></i>
									</span>
								</div>
							{else}
								<div class="dropdown-item pointer js_theme-mode" data-mode="night">
									<span class="js_theme-mode-text">Night Mode</span>
									<span class="pull-right">
										<i class="js_theme-mode-icon fas fa-moon"></i>
									</span>
								</div>
							{/if}
						</div>
					</li>
				{else}
					<li class="dropdown float-right">
						<a href="#" class="dropdown-toggle" data-toggle="dropdown" data-display="static">
							<span>Join</span>
						</a>
						<div class="dropdown-menu dropdown-menu-right">
							<a class="dropdown-item" href="{$base_uri}/signin">Login</a>
							{if $registration_enabled}
								<a class="dropdown-item" href="{$base_uri}/signup">Register</a>
							{/if}
							{if $theme_mode_night}
								<div class="dropdown-item pointer js_theme-mode" data-mode="day">
									<span class="js_theme-mode-text">Day Mode</span>
									<span class="pull-right">
										<i class="js_theme-mode-icon fas fa-sun"></i>
									</span>
								</div>
							{else}
								<div class="dropdown-item pointer js_theme-mode" data-mode="night">
									<span class="js_theme-mode-text">Night Mode</span>
									<span class="pull-right">
										<i class="js_theme-mode-icon fas fa-moon"></i>
									</span>
								</div>
							{/if}
						</div>
					</li>
				{/if}
			</ul>
		</div>

	</div>
</div>
