<div class="modal-header">
    <h5 class="modal-title">Orders</h5>
    <span class="modal-close" data-dismiss="modal" aria-label="Close">
        <i class="fa fa-times"></i>
    </span>
</div>
<div class="modal-body">

    {if count($orders) > 0}
        <div class="table-responsive">
            <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                <thead>
                    <tr>
                        <th>DATE</th>
                        <th>ORDER</th>
                        <th>TRANSACTION TYPE</th>
                        <th>AMOUNT</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach $orders as $order}
                        <tr>
                            <td>
                                {if $order.status == "10"}
                                    <span class="js_moment" data-time="{$order.approvedAt}">{$order.approvedAt}</span>
                                {elseif $order.status == "11"}
                                    <span class="js_moment" data-time="{$order.finishedAt}">{$order.finishedAt}</span>
                                {/if}
                            </td>
                            <td>
                                <strong><a target="_blank" href="{$base_uri}/order/{$order.id}">#{$order.id}</a></strong>
                            </td>
                            <td>
                                {$order.statusTitle} ({$order.pages} pages)
                            </td>
                            <td class="text-right">
                                {if $employee.is_writer}
                                    <strong class="text-success">+ {$order.writerPayFormatted}</strong>
                                {elseif $employee.is_editor}
                                    <strong class="text-success">+ {$order.editorPayFormatted}</strong>
                                {else}
                                    <strong class="text-danger">+ $0.00</strong>
                                {/if}
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
                <tfoot>
                    {if $pay_delivered_orders || $done_orders_pay}
                        <tr style="display: table-row;">
                            <th class="text-right" align="right" colspan="3">Completed orders:</th>
                            <td class="text-right">
                                <strong class="text-success">+ {formatPrice($done_orders_pay)}</strong>
                            </td>
                        </tr>
                    {/if}
                    <tr style="display: table-row;">
                        <th class="text-right" align="right" colspan="3">Approved orders:</th>
                        <td class="text-right">
                            <strong class="text-success">+ {formatPrice($completed_orders_pay)}</strong>
                        </td>
                    </tr>

                    {if $total_credit || $total_fine}
                        <tr style="display: table-row;">
                            <th class="text-right" align="right" colspan="3">Sub Total:</th>
                            <td class="text-right">
                                <strong class="text-success">+ {formatPrice($subtotal_pay)}</strong>
                            </td>
                        </tr>
                    {/if}

                    {if $total_credit}
                        <tr style="display: table-row;">
                            <th class="text-right" align="right" colspan="3">Credit:</th>
                            <td class="text-right">
                                <strong class="text-warning">+ {formatPrice($total_credit)}</strong>
                            </td>
                        </tr>
                    {/if}

                    {if $total_fine}
                        <tr style="display: table-row;">
                            <th class="text-right" align="right" colspan="3">Fine:</th>
                            <td class="text-right">
                                <strong class="text-danger">- {formatPrice($total_fine)}</strong>
                            </td>
                        </tr>
                    {/if}

                    <tr style="display: table-row;">
                        <th class="text-right" align="right" colspan="3">Total:</th>
                        <td class="text-right">
                            <strong class="{if $total_pay < 0}text-danger{else}text-success{/if}">+ {formatPrice($total_pay)}</strong>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    {else}
        <div class="text-center x-muted"> 
            <img class="mb20" width="15%" src="/static/images/no_results.png">
            <p class="mb10"><strong>The list is empty.</strong></p>
        </div>
    {/if}

</div>