{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
<div class="card">
    <div class="card-header with-icon with-nav">
        <div class="mb20">  

            {if $controller == "paperTypes"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addPaperTypeModal" data-size="small" class="btn btn-success">
                        <i class="fa fa-check-circle"></i> {if $article_writing_enabled}Add Project{else}Add Paper Type{/if}
                    </button>
                </div>
            {/if}

            {if $controller == "disciplines"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addDisciplineModal" data-size="medium" class="btn btn-success">
                        <i class="fa fa-check-circle"></i> {if $article_writing_enabled}Add Category{else}Add Discipline{/if} 
                    </button>
                </div>
            {/if}

            {if !$article_writing_enabled && $controller == "paperFormats"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addPaperFormatModal" data-size="small" class="btn btn-success">
                        <i class="fa fa-check-circle"></i> Add Paper Format
                    </button>
                </div>
            {/if}

            {if $controller == "uploadTypes"}
                <div class="pull-right flip">
                    <button type="button"  data-toggle="modal" data-url="#addUploadTypeModal" data-size="small" class="btn btn-success">
                        <i class="fa fa-check-circle"></i> Add Upload Type
                    </button>
                </div>
            {/if}

            <i class="fa fa-cogs mr10"></i> 
            <strong>Preferences</strong>
        </div>
        <ul class="nav nav-tabs">
            
            <li {if $controller == "paperTypes"}class="active"{/if}>
                <a href="{$base_uri}/system/preferences/paper-types"> 
                    {if $controller == "paperTypes"}
                        <strong class="pr5">{if $article_writing_enabled}Projects{else}Paper Types{/if}</strong>
                    {else}
                        {if $article_writing_enabled}Projects{else}Paper Types{/if}  
                    {/if} 
                </a>
            </li>

            <li {if $controller == "disciplines"}class="active"{/if}>
                <a href="{$base_uri}/system/preferences/disciplines"> 
                    {if $controller == "disciplines"}
                        <strong class="pr5">{if $article_writing_enabled}Categories{else}Disciplines{/if}</strong>
                    {else}
                        {if $article_writing_enabled}Categories{else}Disciplines{/if}
                    {/if} 
                </a>
            </li>

            {if !$article_writing_enabled}
                <li {if $controller == "paperFormats"}class="active"{/if}>
                    <a href="{$base_uri}/system/preferences/paper-formats"> 
                        {if $controller == "paperFormats"}<strong class="pr5">Paper Formats</strong>{else}Paper Formats{/if} 
                    </a>
                </li>
            {/if}

            <li {if $controller == "uploadTypes"}class="active"{/if}>
                <a href="{$base_uri}/system/preferences/upload-types"> 
                    {if $controller == "uploadTypes"}<strong class="pr5">Upload Types</strong>{else}Upload Types{/if} 
                </a>
            </li>
        </ul>
    </div>

    <div class="card-body">
        {include file="dashboard/customize/$controller.tpl"}
    </div>
</div>
{/block}