{if count($disciplineGroups)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Complex Assignment</th>
                    <th>Actions</th>
                </tr>
            </thead> 
            <tbody>
                {foreach $disciplineGroups as $disciplines}
                    {foreach $disciplines as $discipline}
                        <tr>
                            <td>{$discipline.discipline_id}</td>
                            <td>
                                {$discipline.title} {if isset($disciplineGroups[$discipline.discipline_id])}<span class="badge badge-info">Group</span>{/if}
                            </td>
                            <td>
                                {if $discipline.is_complex_assignment}
                                    <span class="fa fa-check text-success"></span>
                                {else}
                                    <span class="fa fa-times text-danger"></span>
                                {/if}
                            </td>
                            <td>
                                {if $discipline.discipline_id != '52'}
                                    <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="discipline" data-id="{$discipline.discipline_id}">
                                        <i class="fa fa-trash-alt"></i>
                                    </button>
                                {/if}
                                <button type="button" data-toggle="modal" data-url="#editDisciplineModal" data-size="medium" data-options='{$discipline|json_encode nofilter}' class="btn btn-xs btn-primary">
                                    <i class="fa fa-pencil-alt"></i>
                                </button>
                            </td>
                        </tr>
                    {/foreach}
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="/static/images/no_results.png">
        <p class="mb10"><strong>No disciplines to show</strong></p>
    </div>
{/if}

<!-- Add Discipline -->
<script id="addDisciplineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addDiscipline" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">{if $article_writing_enabled}Add Category{else}Add Discipline{/if}</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control">
            </div>

            {if count($disciplineGroups)}
                <div class="form-group">
                    <label class="control-label">{if $article_writing_enabled}Category{else}Discipline{/if} group</label>
                    <select class="form-control" name="discipline_group">
                        <option value="-1">None</option>
                        {foreach $disciplineGroups as $disciplines}
                            {foreach $disciplines as $discipline}
                                    <option value="{$discipline.discipline_id}">{$discipline.title}</option>
                            {/foreach}
                        {/foreach}
                    </select>
                    <span class="help-block">
                        {if $article_writing_enabled}Categories{else}Disciplines{/if} have groups. You might have a Chemistry discipline under Formal Science group. Totally optional.
                    </span>
                </div>
            {/if}

            <div class="form-table-row mb0"> 
                <div> 
                    <div class="form-control-label h5">Complex Assignment</div> 
                    <div class="form-text d-none d-sm-block">Charge an extra 20% for the complexity of this {if $article_writing_enabled}category{else}discipline{/if}</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">{if $article_writing_enabled}Add Category{else}Add Discipline{/if}</button>
        </div>
    </form>
</script>
<!-- Add Discipline -->

<!-- Edit Discipline -->
<script id="editDisciplineModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editDiscipline" method="POST" autocomplete="off">
        <input type="hidden" name="discipline_id" value="{literal}{{discipline_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit {if $article_writing_enabled}Category{else}Discipline{/if}</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control" value="{literal}{{title}}{/literal}">
            </div>

            {if count($disciplineGroups)}
                <div class="form-group">
                    <label class="control-label">{if $article_writing_enabled}Category{else}Discipline{/if} group</label>
                    <select class="form-control" name="discipline_group">
                        <option value="-1">None</option>
                        {foreach $disciplineGroups as $disciplines}
                            {foreach $disciplines as $discipline}
                                <option value="{$discipline.discipline_id}" {literal}{{#group_id={/literal}{$discipline.discipline_id}{literal}}}{/literal}selected=""{literal}{{/group_id={/literal}{$discipline.discipline_id}{literal}}}{/literal}>{$discipline.title}</option>
                            {/foreach}
                        {/foreach}
                    </select>
                    <span class="help-block">
                        {if $article_writing_enabled}Categories{else}Disciplines{/if} have groups. You might have a Chemistry discipline under Formal Science group. Totally optional.
                    </span>
                </div>
            {/if}

            <div class="form-table-row mb0"> 
                <div> 
                    <div class="form-control-label h5">Complex Assignment</div> 
                    <div class="form-text d-none d-sm-block">Charge an extra 20% for the complexity of this {if $article_writing_enabled}category{else}discipline{/if}</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="is_complex_assignment"> 
                        <input type="checkbox" name="is_complex_assignment" id="is_complex_assignment" {literal}{{#is_complex_assignment}}{/literal}checked=""{literal}{{/is_complex_assignment}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Discipline -->