{if count($paper_formats)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $paper_formats as $paper_format}
                    <tr>
                        <td>{$paper_format.paper_format_id}</td>
                        <td>{$paper_format.title}</td>
                        <td width="200px">
                            {if $paper_format.paper_format_id != '4'}
                                <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="paper_format" data-id="{$paper_format.paper_format_id}">
                                    <i class="fa fa-trash-alt"></i>
                                </button>
                            {/if}
                            <button type="button" data-toggle="modal" data-url="#editPaperFormatModal" data-size="small" data-options='{$paper_format|json_encode nofilter}' class="btn btn-xs btn-primary">
                                <i class="fa fa-pencil-alt"></i>
                            </button>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="/static/images/no_results.png">
        <p class="mb10"><strong>No paper formats to show</strong></p>
    </div>
{/if}

<!-- Add Paper Format -->
<script id="addPaperFormatModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addPaperFormat" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Paper Format</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control" required>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Paper Format</button>
        </div>
    </form>
</script>
<!-- Add Paper Format -->

<!-- Edit Paper Format -->
<script id="editPaperFormatModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editPaperFormat" method="POST" autocomplete="off">
        <input type="hidden" name="paper_format_id" value="{literal}{{paper_format_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Paper Format</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control" value="{literal}{{title}}{/literal}" required>
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Paper Format -->