{if count($uploadTypes)}
    <div class="table-responsive">
        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Customer</th>
                    <th>Writer</th>
                    <th>Editor</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                {foreach $uploadTypes as $upload_type}
                    <tr>
                        <td>{$upload_type.upload_type_id}</td>
                        <td>{$upload_type.title}</td>
                        <td>
                            {if $upload_type.customer}
                                <span class="fa fa-check text-success"></span>
                            {else}
                                <span class="fa fa-times text-danger"></span>
                            {/if}
                        </td>
                        <td>
                            {if $upload_type.writer}
                                <span class="fa fa-check text-success"></span>
                            {else}
                                <span class="fa fa-times text-danger"></span>
                            {/if}
                        </td>
                        <td>
                            {if $upload_type.editor}
                                <span class="fa fa-check text-success"></span>
                            {else}
                                <span class="fa fa-times text-danger"></span>
                            {/if}
                        </td>
                        <td>
                            {if $upload_type.upload_type_id != '39'}
                                <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="upload_type" data-id="{$upload_type.upload_type_id}">
                                    <i class="fa fa-trash-alt"></i>
                                </button>
                            {/if}
                            <button type="button" data-toggle="modal" data-url="#editUploadTypeModal" data-size="small" data-options='{$upload_type|json_encode nofilter}' class="btn btn-xs btn-primary">
                                <i class="fa fa-pencil-alt"></i>
                            </button>
                        </td>
                    </tr>
                {/foreach}
            </tbody>
        </table>

        {$pager nofilter}
    </div>
{else}
    <div class="text-center x-muted"> 
        <img class="mb20" width="15%" src="/static/images/no_results.png">
        <p class="mb10"><strong>No upload types to show</strong></p>
    </div>
{/if}

<!-- Add Upload Type -->
<script id="addUploadTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=addUploadType" method="POST" autocomplete="off">
        <div class="modal-header">
            <h5 class="modal-title">Add Upload Type</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control">
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Customer</div> 
                    <div class="form-text d-none d-sm-block">Show this option to customers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="customer"> 
                        <input type="checkbox" name="customer" id="customer"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Writer</div> 
                    <div class="form-text d-none d-sm-block">Show this option to writers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="writer"> 
                        <input type="checkbox" name="writer" id="writer"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">Editor</div> 
                    <div class="form-text d-none d-sm-block">Show this option to editors</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="editor"> 
                        <input type="checkbox" name="editor" id="editor"> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Add Upload Type</button>
        </div>
    </form>
</script>
<!-- Add Upload Type -->

<!-- Edit Upload Type -->
<script id="editUploadTypeModal" type="text/template">
    <form class="js_ajax-forms p0 m0" data-url="/preferences?do=editUploadType" method="POST" autocomplete="off">
        <input type="hidden" name="upload_type_id" value="{literal}{{upload_type_id}}{/literal}">
        <div class="modal-header">
            <h5 class="modal-title">Edit Upload Type</h5>
            <span class="modal-close" data-dismiss="modal" aria-label="Close">
                <i class="fa fa-times"></i>
            </span>
        </div>

        <div class="modal-body">
            <div class="form-group">
                <label class="control-label">Title</label>
                <input name="title" type="text" class="form-control" value="{literal}{{title}}{/literal}">
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Customer</div> 
                    <div class="form-text d-none d-sm-block">Show this option to customers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="customer"> 
                        <input type="checkbox" name="customer" id="customer" {literal}{{#customer}}{/literal}checked=""{literal}{{/customer}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row"> 
                <div> 
                    <div class="form-control-label h5">Writer</div> 
                    <div class="form-text d-none d-sm-block">Show this option to writers</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="writer"> 
                        <input type="checkbox" name="writer" id="writer" {literal}{{#writer}}{/literal}checked=""{literal}{{/writer}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <div class="form-table-row mb10"> 
                <div> 
                    <div class="form-control-label h5">Editor</div> 
                    <div class="form-text d-none d-sm-block">Show this option to editors</div> 
                </div> 
                <div class="text-right"> 
                    <label class="switch" for="editor"> 
                        <input type="checkbox" name="editor" id="editor" {literal}{{#editor}}{/literal}checked=""{literal}{{/editor}}{/literal}> 
                        <span class="slider round"></span> 
                    </label> 
                </div> 
            </div>

            <!-- success -->
            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
            <!-- success -->

            <!-- error -->
            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
            <!-- error -->
        </div>
        
        <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-primary" id="modal-confirm-ok">Save Changes</button>
        </div>
    </form>
</script>
<!-- Edit Upload Type -->