{extends file='dashboard/layout.tpl'} 

{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-comments-o mr10"></i> 
            <strong>Feedback</strong> 
            {if $sub_view == "employee_feedback"} &rsaquo; <strong>Employee</strong> &rsaquo; <strong>{$employee_name}</strong>{/if}
        </div>

        {if $sub_view == "feedback" || $sub_view == "employee_feedback"}

            <div class="card-body">
                <div class="rating mb20">
                    <span class="heading">Rating</span>
                    
                    {$rating = $insights['average_rating']}

                    {foreach range(1,5) as $i}
                        {if $rating > 0}
                            {if $rating > 0.5}
                                <i class="fa fa-star checked"></i>
                            {else}
                                <i class="fa fa-star-half checked"></i>
                            {/if}
                        {else}
                            <i class="fa fa-star"></i>
                        {/if}

                        {$rating = $rating-1}
                    {/foreach}

                    <p>{$insights['average_rating']} average based on {$insights['total_reviews']} reviews.</p>
                    <hr style="border: 3px solid #f1f1f1;" />
                    
                    <div class="rating-row">
                        {foreach range(1,5) as $i}
                            <div class="side">
                                <div>{$i} star</div>
                            </div>
                            {if isset($insights['ratings'][$i])}
                                <div class="middle">
                                    <div class="bar-container">
                                        <div class="bar-{$i}" style="width: {$insights['ratings'][$i]['width']}%;"></div>
                                    </div>
                                </div>
                                <div class="side right">
                                    <div>{$insights['ratings'][$i]['total_rating']}</div>
                                </div>
                            {else}
                                <div class="middle">
                                    <div class="bar-container">
                                        <div class="bar-{$i}" style="width: 0%;"></div>
                                    </div>
                                </div>
                                <div class="side right">
                                    <div>0</div>
                                </div>
                            {/if}
                        {/foreach}
                    </div>
                </div>

                {if count($ratings)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} ratings table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <td>Order ID</td>
                                    <td>Service Rating</td>
                                    <td>Paper Rating</td>
                                    <td>Paper on Time</td>
                                    <td>Date</td>
                                    <td>Actions</td>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $ratings as $rating}
                                    <tr>
                                        <td>
                                            <a target="_blank" href="{$base_uri}/order/{$rating.order_id}">#{$rating.order_id}</a>
                                        </td>
                                        <td>    
                                            {$rating.service_rating/2}
                                            {$rating_star = $rating.service_rating/2}
                                            {foreach range(1,5) as $i}
                                                {if $rating_star > 0}
                                                    {if $rating_star > 0.5}
                                                        <i class="fa fa-star checked"></i>
                                                    {else}
                                                        <i class="fa fa-star-half checked"></i>
                                                    {/if}
                                                {else}
                                                    <i class="fa fa-star text-secondary"></i>
                                                {/if}

                                                {$rating_star = $rating_star-1}
                                            {/foreach}
                                        </td>
                                        <td>    
                                            {$rating.paper_rating/2}
                                            {$rating_star = $rating.paper_rating/2}
                                            {foreach range(1,5) as $i}
                                                {if $rating_star > 0}
                                                    {if $rating_star > 0.5}
                                                        <i class="fa fa-star checked"></i>
                                                    {else}
                                                        <i class="fa fa-star-half checked"></i>
                                                    {/if}
                                                {else}
                                                    <i class="fa fa-star text-secondary"></i>
                                                {/if}

                                                {$rating_star = $rating_star-1}
                                            {/foreach}
                                        </td>
                                        <td>
                                            {if $rating.paper_on_time}
                                                <span class="label label-success">Yes</span>
                                            {else}
                                                <span class="label label-danger">No</span>
                                            {/if}
                                        </td>
                                        <td>
                                            <span class="js_moment" data-time="{$rating.date}">{$rating.date}</span>
                                        </td>
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="rating" data-id="{$rating.id}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <a data-toggle="tooltip" data-placement="top" title="View" href="{$base_uri}/feedback/{$rating.id}" class="btn btn-xs btn-primary">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> <i class="fa fa-envelope fa-4x"></i>
                        <p class="mb10"><strong>No ratings to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "view"}
            <div class="card-body">
                <table width="100%" cellspacing="0" cellpadding="0" border="0" class="table_info ratings">
                    <tbody>
                        <tr class="first">
                            <th>Order ID:</th>
                            <td>
                                <a target="_blank" href="{$base_uri}/order/{$feedback.order_id}">#{$feedback.order_id}</a>
                            </td>
                        </tr>
                        <tr class="first">
                            <th>Customer ID:</th>
                            <td>
                                {if $user.is_sub_admin}
                                    {$feedback.order.customer.id}
                                {else}
                                    <a target="_blank" href="{$base_uri}/customers/edit/{$feedback.order.customer.id}">#{$feedback.order.customer.id}</a>
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <th>Service Rating:</th>
                            <td>{$feedback.paper_rating/2} {starRating($feedback.paper_rating) nofilter}</td>
                        </tr>
                        <tr>
                            <th>Paper Rating:</th>
                            <td>{$feedback.service_rating/2} {starRating($feedback.service_rating) nofilter}</td>
                        </tr>
                        <tr>
                            <th>Paper on Time:</th>
                            <td>
                                {if $feedback.paper_on_time}
                                    <span class="label label-success">Yes</span>
                                {else}
                                    <span class="label label-danger">No</span>
                                {/if}
                            </td>
                        </tr>
                        <tr>
                            <th>Comments:</th>
                            <td>{$feedback.comment}</td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-toggle="modal" data-url="#modal-feedback" data-options='{literal}{{/literal}"feedback_id":{$feedback.id}{literal}}{/literal}' class="btn btn-primary">Reply</button>
            </div>
            
        {/if}

    </div> 
{/block}