<!doctype html>
<html lang="en-US">
  	<head>
		{block name='head'}
			{include file='_partials/head.tpl'}
		{/block}
	</head>

	<body class="{$body_classes|classnames} {if $theme_mode_night}night-mode{/if}">
        <div class="main-wrapper">

			{block name='header'}
				{include file='_partials/header.tpl'}
			{/block}

			<div class="container mt20 offcanvas">
				<div class="row">
					<!-- left panel -->
					<div class="col-sm-3 offcanvas-sidebar">
						<div class="card">
							<div class="panel-body with-nav">
								<ul class="side-nav metismenu js_metisMenu">

									{hook h='displayAdminNavBarBeforeStart'}
									
									{if $user.is_admin || $user.is_sub_admin}
										<li {if $view == "create"}class="active"{/if}>
											<a href="{$base_uri}/orders/create">
												<i class="fa fa-plus fa-fw fa-lg pr30"></i> Create order
											</a>
										</li>
									{/if}

									<!-- Orders -->
									<li {if $view == "orders"}class="active"{/if}>
										<a href="{$base_uri}/orders/available">
											<i class="fa fa-shopping-basket fa-fw fa-lg pr30"></i> Orders
                               				<span class="fa arrow"></span>
										</a>
										<ul>
											{if $user.is_admin || $user.is_sub_admin}
												<li {if $view == "orders" && $sub_view == "all"}class="active"{/if}>
													<a href="{$base_uri}/orders/all">
														All Orders
													</a>
												</li>

                        						<li {if $view == "orders" && $sub_view == "unpaid"}class="active"{/if}>
													<a href="{$base_uri}/orders/unpaid">
														Unpaid  {if $stats.unpaid}<span class="badge badge-dark pull-right">{$stats.unpaid}</span>{/if}
													</a>
												</li>

												<li {if $view == "orders" && $sub_view == "new-paid"}class="active"{/if}>
													<a href="{$base_uri}/orders/new-paid">
														New paid orders {if $stats.new_paid}<span class="badge badge-dark pull-right">{$stats.new_paid}</span>{/if}
													</a>
												</li>
											{/if}
											
											<li {if $view == "orders" && $sub_view == "available"}class="active"{/if}>
												<a href="{$base_uri}/orders/available">
													Available orders {if $stats.available}<span class="badge badge-dark pull-right">{$stats.available}</span>{/if}
												</a>
											</li>

											{if !$user.is_editor}
												<li {if $view == "orders" && $sub_view == "bids"}class="active"{/if}>
													<a href="{$base_uri}/orders/bids">
														Bids {if $stats.bids}<span class="badge badge-dark pull-right">{$stats.bids}</span>{/if}
													</a>
												</li>
											{/if}

											{if $confirm_order_assign && ($user.is_admin || $user.is_sub_admin || $user.is_writer)}
												<li {if $view == "orders" && $sub_view == "unconfirmed"}class="active"{/if}>
													<a href="{$base_uri}/orders/unconfirmed">
														Unconfirmed Orders {if $stats.unconfirmed}<span class="badge badge-dark pull-right">{$stats.unconfirmed}</span>{/if}
													</a>
												</li>
											{/if}

											<li {if $view == "orders" && $sub_view == "progress"}class="active"{/if}>
												<a href="{$base_uri}/orders/progress">
													Orders in Progress {if $stats.progress}<span class="badge badge-dark pull-right">{$stats.progress}</span>{/if}
												</a>
											</li>

											{if $editor_account_enabled && !$user.is_editor}
												<li {if $view == "orders" && $sub_view == "done"}class="active"{/if}>
													<a href="{$base_uri}/orders/done">
														Editing/Done {if $stats.done}<span class="badge badge-dark pull-right">{$stats.done}</span>{/if}
													</a>
												</li>
											{/if}

											<li {if $view == "orders" && $sub_view == "delivered"}class="active"{/if}>
												<a href="{$base_uri}/orders/delivered">
													Delivered orders {if $stats.delivered}<span class="badge badge-dark pull-right">{$stats.delivered}</span>{/if}
												</a>
											</li>

											<li {if $view == "orders" && $sub_view == "revision"}class="active"{/if}>
												<a href="{$base_uri}/orders/revision">
													Revision orders {if $stats.revision}<span class="badge badge-danger pull-right">{$stats.revision}</span>{/if}
												</a>
											</li>

											<li {if $view == "orders" && $sub_view == "finished"}class="active"{/if}>
												<a href="{$base_uri}/orders/finished">
													Finished orders {if $stats.finished}<span class="badge badge-dark pull-right">{$stats.finished}</span>{/if}
												</a>
											</li>

											<li {if $view == "orders" && $sub_view == "dispute"}class="active"{/if}>
												<a href="{$base_uri}/orders/dispute">
													Dispute orders {if $stats.disputes}<span class="badge badge-warning pull-right">{$stats.disputes}</span>{/if}
												</a>
											</li>

											{if $user.is_admin || $user.is_sub_admin}
												<li {if $view == "orders" && $sub_view == "inquiry"}class="active"{/if}>
													<a href="{$base_uri}/orders/inquiry">
														Inquiry {if $stats.inquiry}<span class="badge badge-dark pull-right">{$stats.inquiry}</span>{/if}
													</a>
												</li>
												<li {if $view == "orders" && $sub_view == "cancelled"}class="active"{/if}>
													<a href="{$base_uri}/orders/cancelled">
														Cancelled orders {if $stats.cancelled}<span class="badge badge-dark pull-right">{$stats.cancelled}</span>{/if}
													</a>
												</li>
											{/if}

										</ul>
									</li>
									<!-- Orders -->

									<!-- Messages -->
									<li {if $view == "messages"}class="active"{/if}>
										<a href="{$base_uri}/messages">
											<i class="fa fa-envelope fa-fw fa-lg pr30"></i> Messages
										</a>
									</li>
									<!-- Messages -->

									{if $user.is_admin || $user.is_sub_admin}
										<!-- Feedback -->
										<li {if $view == "feedback"}class="active"{/if}>
											<a href="{$base_uri}/feedback">
												<i class="fa fa-comments fa-fw fa-lg pr30"></i> Feedback
											</a>
										</li>
										<!-- Feedback -->
									{/if}

									<!-- Profile -->
									<li {if $view == "profile"}class="active"{/if}>
										<a href="{$base_uri}/profile">
											<i class="fa fa-user fa-fw fa-lg pr30"></i> Profile
										</a>
									</li>
									<!-- Profile -->

									{if $user.is_writer || $user.is_editor}
										<!-- Finacial Overview -->
										<li {if $view == "financial-overview"}class="active"{/if}>
											<a href="{$base_uri}/financial-overview">
												<i class="fa fa-money-bill-alt fa-fw fa-lg pr30"></i> Finacial overview
											</a>
										</li>
										<!-- Finacial Overview -->
									{/if}

									{if $user.is_admin}
										<!-- Payments -->
										<li {if $view == "payments"}class="active"{/if}>
											<a href="{$base_uri}/payments">
												<i class="fa fa-money-bill-alt fa-fw fa-lg pr30"></i> Payments
											</a>
										</li>
										<!-- Payments -->

										<!-- Coupons -->
										<li {if $view == "coupons"}class="active"{/if}>
											<a href="{$base_uri}/coupons">
												<i class="fa fa-tag fa-fw fa-lg pr30"></i> Coupons
											</a>
										</li>
										<!-- Coupons -->

										<!-- Users -->
										<li {if $view == "users"}class="active"{/if}>
											<a href="{$base_uri}/customers">
												<i class="fa fa-users fa-fw fa-lg pr30"></i> Users
												<span class="fa arrow"></span>
											</a>
											<ul>
												<li {if $view == "users" && $sub_view == "customers"}class="active"{/if}>
													<a href="{$base_uri}/customers">
														Customers
													</a>
												</li>
												<li {if $view == "users" && $sub_view == "writers"}class="active"{/if}>
													<a href="{$base_uri}/employees/writers">
														Writers
													</a>
												</li>
												<li {if $view == "users" && $sub_view == "editors"}class="active"{/if}>
													<a href="{$base_uri}/employees/editors">
														Editors
													</a>
												</li>
												<li {if $view == "users" && $sub_view == "sub-admins"}class="active"{/if}>
													<a href="{$base_uri}/employees/sub-admins">
														Sub Admins
													</a>
												</li>
												<li {if $view == "users" && $sub_view == "administrators"}class="active"{/if}>
													<a href="{$base_uri}/employees/administrators">
														Administrators
													</a>
												</li>
											</ul>
										</li>
										<!-- Users -->

										{hook h='displayAdminNavBarBeforeEnd'}

										<!-- Settings -->
										<li {if $view == "system"}class="active"{/if}>
											<a href="{$base_uri}/system/settings">
												<i class="fa fa-cog fa-fw fa-lg pr30"></i> Settings
												<span class="fa arrow"></span>
											</a>
											<ul>

												{hook h='displayAdminSettingsNavBarBeforeStart'}

												<li {if $view == "system" && $sub_view == "settings"}class="active"{/if}>
													<a href="{$base_uri}/system/settings">
														<i class="fa fa-cog fa-fw mr10"></i> System Settings
													</a>
												</li>
												</li>
												<li {if $view == "system" && $sub_view == "currency"}class="active"{/if}>
													<a href="{$base_uri}/system/currency">
														<i class="fa fa-money-bill-alt fa-fw mr10"></i> Currency
													</a>
												</li>
												<li {if $view == "system" && $sub_view == "preferences"}class="active"{/if}>
													<a href="{$base_uri}/system/preferences">
														<i class="fa fa-cogs fa-fw mr10"></i> Preferences
													</a>
												</li>
												<li {if $view == "system" && $sub_view == "uploads"}class="active"{/if}>
													<a href="{$base_uri}/system/uploads">
														<i class="fa fa-upload fa-fw mr10"></i> Uploads Settings
													</a>
												</li>

												{hook h='displayAdminSettingsNavBarBeforeEnd'}
											</ul>
										</li>
										<!-- Settings -->

										<!-- My Sites -->
										<li {if $view == "my-sites"}class="active"{/if}>
											<a href="{$base_uri}/my-sites">
												<i class="fa fa-globe fa-fw fa-lg pr30"></i> My Sites
											</a>
										</li>
										<!-- My Sites -->

										<!-- Mailing -->
										<li {if $view == "mailing"}class="active"{/if}>
											<a href="{$base_uri}/mailing/send">
												<i class="fa fa-paper-plane fa-fw fa-lg pr30"></i> Mailing
												<span class="fa arrow"></span>
											</a>
											<ul>
												<li {if $view == "mailing" && $sub_view == "send"}class="active"{/if}>
													<a href="{$base_uri}/mailing/send">
														<i class="fa fa-caret-right fa-fw pr10"></i> Send Email
													</a>
												</li>
												<li {if $view == "mailing" && $sub_view == "mails"}class="active"{/if}>
													<a href="{$base_uri}/mailing/mails">
														<i class="fa fa-caret-right fa-fw pr10"></i> List Mails
													</a>
												</li>
												<li {if $view == "mailing" && $sub_view == "add"}class="active"{/if}>
													<a href="{$base_uri}/mailing/add">
														<i class="fa fa-caret-right fa-fw pr10"></i> Add New Mail
													</a>
												</li>
											</ul>
										</li>
										<!-- Mailing -->

										<!-- Addons -->
										<li {if $view == "modules"}class="active"{/if}>
											<a href="{$base_uri}/modules">
												<i class="fa fa-plug fa-fw fa-lg pr30"></i> Addons
											</a>
										</li>
										<!-- Addons -->

										{hook h='displayAdminNavBarAfterEnd'}

										<!-- Updates -->
										<li>
											<a href="{$base_uri}/updates" class="static">
												<i class="fa fa-copyright fa-fw fa-lg pr30"></i>
												Version {$system_version} {if $new_version}<span class="badge badge-pill badge-success pull-right">New</span>{/if}
											</a>
										</li>
										<!-- Updates -->

									{/if}
								</ul>
							</div>
						</div>
					</div>
					<!-- left panel -->

					<!-- right panel -->
					<div class="col-sm-9 offcanvas-mainbar">
						{block name='content_wrapper'}{/block}
					</div>
					<!-- right panel -->
				</div>
			</div>

        </div>
	</body>

    {include file="_partials/_js_files.tpl"}

	{if $user.logged}
		<!-- Notification -->
		<audio id="notification_sound" preload="auto">
			<source src="{$base_uri}/static/sounds/notification.mp3" type="audio/mpeg">
		</audio>
		<!-- Notification -->
		<!-- Chat -->
		<audio id="chat_sound" preload="auto">
			<source src="{$base_uri}/static/sounds/chat.mp3" type="audio/mpeg">
		</audio>
		<!-- Chat -->
	{/if}

	{block name='hook_footer_after'}
        {hook h='displayFooterAfter'}
    {/block}

</html>
