{extends file='dashboard/layout.tpl'} 
 
{block name='content_wrapper'}
    <div class="card">
        <div class="card-header with-icon">
            <i class="fa fa-paper-plane mr10"></i> 
            {if $sub_view == "mails"}
                <div class="pull-right flip"> 
                    <a href="{$base_uri}/mailing/add" class="btn btn-primary"> 
                        <i class="fa fa-plus"></i> Add New Mail
                    </a> 
                </div>
            {/if}

            <strong>Mailing</strong> 
            {if $sub_view == "send"} &rsaquo; <strong>Send</strong>{/if}
            {if $sub_view == "mails"} &rsaquo; <strong>Mails</strong> &rsaquo; <strong>{$total_mails}</strong>{/if}
            {if $sub_view == "add"} &rsaquo; <strong>Add New</strong>{/if}
            {if $sub_view == "edit"} &rsaquo; <strong>Edit</strong> &rsaquo; <strong>{$mail['email']}</strong>{/if}
        </div>

        {if $sub_view == "send"}
            
            <div class="card-body row">
                <form class="js_ajax-forms col-md-9" data-url="/admin/mailing?do=send_mail" autocomplete="off">
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">
                            Subject
                        </label>
                        <div class="col-sm-10">  
                            <input class="form-control" type="text" name="subject">
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">
                            Message
                        </label>
                        <div class="col-sm-10">  
                            <textarea class="form-control" id="summernote" rows="10" name="message"></textarea>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label text-left">
                            Send to
                        </label>
                        <div class="col-sm-10">
                            <select class="form-control" name="recipient" data-combo="recipient">
                                <option value="1">Select from customers</option>
                                <option value="2">Select from writers</option>
                                <option value="7">Select from sites</option>
                                <option value="3">Select from mailing list</option>
                                <option value="4">All customers</option>
                                <option value="5">All writers</option>
                                <option value="6">All mailing list</option>
                            </select>
                        </div>
                    </div>

                    <div id="recipient">
                        <div class="switch-combo" data-combo-value="1">
                            <div class="form-group form-row">
                                <label class="col-sm-2 control-label text-left">Customer</label>
                                <div class="col-sm-10">
                                    <select class="form-control select_search" name="customer_ids[]" multiple="">
                                        {foreach from=$customers item=$site_customers key=$site_name}
                                            <optgroup label="{$site_name}">
                                                {foreach $site_customers as $customer}
                                                    <option value="{$customer.id}">{$customer.id} - {$customer.name}</option>
                                                {/foreach}
                                            </optgroup>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="x-hidden switch-combo" data-combo-value="2">
                            <div class="form-group form-row">
                                <label class="col-sm-2 control-label text-left">Writer</label>
                                <div class="col-sm-10">
                                    <select class="form-control select_search" name="writer_ids[]" multiple="">
                                        {foreach $writers as $writer}
                                            <option value="{$writer.employee_id}">{$writer.employee_id} - {$writer.first_name} {$writer.last_name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="x-hidden switch-combo" data-combo-value="3">
                            <div class="form-group form-row">
                                <label class="col-sm-2 control-label text-left">Mail list</label>
                                <div class="col-sm-10">
                                    <select class="form-control select_search" name="mail_ids[]" multiple="">
                                        {foreach $mailing_list as $mail}
                                            <option value="{$mail.mail_id}">{$mail.name} - {$mail.email}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="x-hidden switch-combo" data-combo-value="7">
                            <div class="form-group form-row">
                                <label class="col-sm-2 control-label text-left">Select Site</label>
                                <div class="col-sm-10">
                                    <select class="form-control select_search" name="site_ids[]" multiple="">
                                        {foreach $mail_sites as $mail_site}
                                            <option value="{$mail_site.site_id}">{$mail_site.name}</option>
                                        {/foreach}
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <label class="col-sm-2 control-label">Test email</label>
                        <div class="col-sm-10">
                            <label class="switch" for="test_email">
                                <input type="checkbox" name="test_email" id="test_email">
                                <span class="slider round"></span>
                            </label>
                            <span class="help-block">The message will be sent to Website Email only</span>
                        </div>
                    </div>

                    <div class="form-group form-row">
                        <div class="col-sm-10 col-sm-offset-2">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Send Mail</button>
                        </div>
                    </div>
                </form>
            </div>
            
        {elseif $sub_view == "mails"}

            <div class="card-body">
                {if count($mails)}
                    <div class="table-responsive">
                        <table class="table {if $theme_mode_night}table-dark{/if} table-striped table-bordered table-hover js_dataTable">
                            <thead>
                                <tr>
                                    <td>Name</td>
                                    <td>Email</td>
                                    <td>Site</td>
                                    <td>Date</td>
                                    <td>Actions</td>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach $mails as $mail}
                                    <tr>
                                        <td>
                                            <a href="{$base_uri}/mailing/edit/{$mail.mail_id}">{$mail.name}</a>
                                        </td>
                                        <td>{$mail.email}</td>
                                        <td>{$mail.site_name}</td>
                                        <td>
                                            <span class="js_moment" data-time="{$mail.date}">{$mail.date}</span>
                                        </td>
                                        <td>
                                            <button data-toggle="tooltip" data-placement="top" title="Delete" class="btn btn-xs btn-danger js_deleter" data-handle="mail" data-id="{$mail.mail_id}">
                                                <i class="fa fa-trash-alt"></i>
                                            </button>
                                            <a data-toggle="tooltip" data-placement="top" title="Edit" href="{$base_uri}/mailing/edit/{$mail.mail_id}" class="btn btn-xs btn-primary">
                                                <i class="fa fa-pencil-alt"></i>
                                            </a>
                                        </td>
                                    </tr>
                                {/foreach}
                            </tbody>
                        </table>

                        {$pager nofilter}
                    </div>
                {else}
                    <div class="text-center x-muted"> <i class="fa fa-envelope fa-4x"></i>
                        <p class="mb10"><strong>No emails to show</strong></p>
                    </div>
                {/if}
            </div>

        {elseif $sub_view == "add"}

            <div class="card-body">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/mailing?do=add_mail" autocomplete="off">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Name (optional)</label>
                        <div class="col-sm-9">  
                            <input class="form-control" type="text" name="name" required="">
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Email</label>
                        <div class="col-sm-9">  
                            <input class="form-control" type="text" name="email" required="">
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Site ID</label>
                        <div class="col-sm-9">  
                            <select class="form-control select_search" name="site_id" required="">
                                {foreach $sites as $site}
                                    <option value="{$site.site_id}">{$site.site_id} - {$site.name}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Add new</button>
                        </div>
                    </div>
                </form>
            </div>

        {elseif $sub_view == "edit"}
            <div class="card-body">
                <form class="js_ajax-forms col-md-9 form-horizontal" data-url="/admin/mailing?do=edit_mail" autocomplete="off">
                    <input type="hidden" name="mail_id" value="{$mail.mail_id}">
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Name (optional)</label>
                        <div class="col-sm-9">  
                            <input class="form-control" type="text" name="name" value="{$mail.name}" required="">
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Email</label>
                        <div class="col-sm-9">  
                            <input class="form-control" type="text" name="email" required="" value="{$mail.email}">
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <label class="col-sm-3 control-label text-left">Site ID</label>
                        <div class="col-sm-9">  
                            <select class="form-control select_search" name="site_id" required="">
                                {foreach $sites as $site}
                                    <option value="{$site.site_id}" {if $mail.site_id == $site.site_id}selected=""{/if}>{$site.site_id} - {$site.name}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>
                    <div class="form-group form-row">
                        <div class="col-sm-9 offset-sm-3">
                            <!-- success -->
                            <div class="alert alert-success mt10 x-hidden" role="alert"></div>
                            <!-- success -->

                            <!-- error -->
                            <div class="alert alert-danger mt10 x-hidden" role="alert"></div>
                            <!-- error -->

                            <button type="submit" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </form>
            </div>
        {/if}
    </div>
{/block}